/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.jose.jws;

import io.pravega.keycloak.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.pravega.keycloak.com.fasterxml.jackson.annotation.JsonInclude;
import io.pravega.keycloak.com.fasterxml.jackson.annotation.JsonProperty;
import io.pravega.keycloak.com.fasterxml.jackson.databind.ObjectMapper;
import io.pravega.keycloak.org.keycloak.jose.jws.Algorithm;
import java.io.IOException;
import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JWSHeader
implements Serializable {
    @JsonProperty(value="alg")
    private Algorithm algorithm;
    @JsonProperty(value="typ")
    private String type;
    @JsonProperty(value="cty")
    private String contentType;
    @JsonProperty(value="kid")
    private String keyId;
    private static final ObjectMapper mapper = new ObjectMapper();

    public JWSHeader() {
    }

    public JWSHeader(Algorithm algorithm, String type, String contentType) {
        this.algorithm = algorithm;
        this.type = type;
        this.contentType = contentType;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public String getType() {
        return this.type;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String toString() {
        try {
            return mapper.writeValueAsString(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

