/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.representations.adapters.config;

import io.pravega.keycloak.com.fasterxml.jackson.annotation.JsonIgnore;
import io.pravega.keycloak.com.fasterxml.jackson.annotation.JsonInclude;
import io.pravega.keycloak.com.fasterxml.jackson.annotation.JsonProperty;
import io.pravega.keycloak.org.keycloak.representations.idm.authorization.ResourceRepresentation;
import io.pravega.keycloak.org.keycloak.representations.idm.authorization.ScopeRepresentation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PolicyEnforcerConfig {
    @JsonProperty(value="enforcement-mode")
    private EnforcementMode enforcementMode = EnforcementMode.ENFORCING;
    @JsonProperty(value="paths")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<PathConfig> paths = new ArrayList<PathConfig>();
    @JsonProperty(value="path-cache")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private PathCacheConfig pathCacheConfig;
    @JsonProperty(value="lazy-load-paths")
    private Boolean lazyLoadPaths = Boolean.FALSE;
    @JsonProperty(value="on-deny-redirect-to")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String onDenyRedirectTo;
    @JsonProperty(value="user-managed-access")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private UserManagedAccessConfig userManagedAccess;
    @JsonProperty(value="claim-information-point")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, Map<String, Object>> claimInformationPointConfig;
    @JsonProperty(value="http-method-as-scope")
    private Boolean httpMethodAsScope;

    public List<PathConfig> getPaths() {
        return this.paths;
    }

    public PathCacheConfig getPathCacheConfig() {
        return this.pathCacheConfig;
    }

    public Boolean getLazyLoadPaths() {
        return this.lazyLoadPaths;
    }

    public void setLazyLoadPaths(Boolean lazyLoadPaths) {
        this.lazyLoadPaths = lazyLoadPaths;
    }

    public EnforcementMode getEnforcementMode() {
        return this.enforcementMode;
    }

    public void setEnforcementMode(EnforcementMode enforcementMode) {
        this.enforcementMode = enforcementMode;
    }

    public UserManagedAccessConfig getUserManagedAccess() {
        return this.userManagedAccess;
    }

    public void setPaths(List<PathConfig> paths) {
        this.paths = paths;
    }

    public void setPathCacheConfig(PathCacheConfig pathCacheConfig) {
        this.pathCacheConfig = pathCacheConfig;
    }

    public String getOnDenyRedirectTo() {
        return this.onDenyRedirectTo;
    }

    public void setUserManagedAccess(UserManagedAccessConfig userManagedAccess) {
        this.userManagedAccess = userManagedAccess;
    }

    public void setOnDenyRedirectTo(String onDenyRedirectTo) {
        this.onDenyRedirectTo = onDenyRedirectTo;
    }

    public Map<String, Map<String, Object>> getClaimInformationPointConfig() {
        return this.claimInformationPointConfig;
    }

    public void setClaimInformationPointConfig(Map<String, Map<String, Object>> config) {
        this.claimInformationPointConfig = config;
    }

    public Boolean getHttpMethodAsScope() {
        return this.httpMethodAsScope;
    }

    public void setHttpMethodAsScope(Boolean httpMethodAsScope) {
        this.httpMethodAsScope = httpMethodAsScope;
    }

    public static class UserManagedAccessConfig {
    }

    public static enum ScopeEnforcementMode {
        ALL,
        ANY,
        DISABLED;

    }

    public static enum EnforcementMode {
        PERMISSIVE,
        ENFORCING,
        DISABLED;

    }

    public static class PathCacheConfig {
        @JsonProperty(value="max-entries")
        int maxEntries = 1000;
        long lifespan = 30000L;

        public int getMaxEntries() {
            return this.maxEntries;
        }

        public void setMaxEntries(int maxEntries) {
            this.maxEntries = maxEntries;
        }

        public long getLifespan() {
            return this.lifespan;
        }

        public void setLifespan(long lifespan) {
            this.lifespan = lifespan;
        }
    }

    public static class MethodConfig {
        private String method;
        private List<String> scopes = new ArrayList<String>();
        @JsonProperty(value="scopes-enforcement-mode")
        private ScopeEnforcementMode scopesEnforcementMode = ScopeEnforcementMode.ALL;

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public List<String> getScopes() {
            return this.scopes;
        }

        public void setScopes(List<String> scopes) {
            this.scopes = scopes;
        }

        public void setScopesEnforcementMode(ScopeEnforcementMode scopesEnforcementMode) {
            this.scopesEnforcementMode = scopesEnforcementMode;
        }

        public ScopeEnforcementMode getScopesEnforcementMode() {
            return this.scopesEnforcementMode;
        }
    }

    public static class PathConfig {
        private String name;
        private String type;
        private String path;
        private List<MethodConfig> methods = new ArrayList<MethodConfig>();
        private List<String> scopes = new ArrayList<String>();
        private String id;
        @JsonProperty(value="enforcement-mode")
        private EnforcementMode enforcementMode = EnforcementMode.ENFORCING;
        @JsonProperty(value="claim-information-point")
        private Map<String, Map<String, Object>> claimInformationPointConfig;
        @JsonIgnore
        private PathConfig parentConfig;

        public static Set<PathConfig> createPathConfigs(ResourceRepresentation resourceDescription) {
            HashSet<PathConfig> pathConfigs = new HashSet<PathConfig>();
            for (String uri : resourceDescription.getUris()) {
                PathConfig pathConfig = new PathConfig();
                pathConfig.setId(resourceDescription.getId());
                pathConfig.setName(resourceDescription.getName());
                if (uri == null || "".equals(uri.trim())) {
                    throw new RuntimeException("Failed to configure paths. Resource [" + resourceDescription.getName() + "] has an invalid or empty URI [" + uri + "].");
                }
                pathConfig.setPath(uri);
                ArrayList<String> scopeNames = new ArrayList<String>();
                for (ScopeRepresentation scope : resourceDescription.getScopes()) {
                    scopeNames.add(scope.getName());
                }
                pathConfig.setScopes(scopeNames);
                pathConfig.setType(resourceDescription.getType());
                pathConfigs.add(pathConfig);
            }
            return pathConfigs;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public List<String> getScopes() {
            return this.scopes;
        }

        public void setScopes(List<String> scopes) {
            this.scopes = scopes;
        }

        public List<MethodConfig> getMethods() {
            return this.methods;
        }

        public void setMethods(List<MethodConfig> methods) {
            this.methods = methods;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public EnforcementMode getEnforcementMode() {
            return this.enforcementMode;
        }

        public void setEnforcementMode(EnforcementMode enforcementMode) {
            this.enforcementMode = enforcementMode;
        }

        public Map<String, Map<String, Object>> getClaimInformationPointConfig() {
            return this.claimInformationPointConfig;
        }

        public void setClaimInformationPointConfig(Map<String, Map<String, Object>> claimInformationPointConfig) {
            this.claimInformationPointConfig = claimInformationPointConfig;
        }

        public String toString() {
            return "PathConfig{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", path='" + this.path + '\'' + ", scopes=" + this.scopes + ", id='" + this.id + '\'' + ", enforcerMode='" + (Object)((Object)this.enforcementMode) + '\'' + '}';
        }

        @JsonIgnore
        public boolean hasPattern() {
            return this.getPath().indexOf("{") != -1;
        }

        @JsonIgnore
        public boolean isInstance() {
            return this.parentConfig != null;
        }

        public void setParentConfig(PathConfig parentConfig) {
            this.parentConfig = parentConfig;
        }

        public PathConfig getParentConfig() {
            return this.parentConfig;
        }
    }
}

