/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.contracts;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.contracts.StreamSegmentException;

public class BadOffsetException
extends StreamSegmentException {
    private static final long serialVersionUID = 1L;
    private final long expectedOffset;
    private final long givenOffset;

    public BadOffsetException(String streamSegmentName, long expectedOffset, long givenOffset) {
        super(streamSegmentName, BadOffsetException.getMessage(expectedOffset, givenOffset));
        this.expectedOffset = expectedOffset;
        this.givenOffset = givenOffset;
    }

    public BadOffsetException(String streamSegmentName, long expectedOffset, long givenOffset, String message) {
        super(streamSegmentName, message);
        this.expectedOffset = expectedOffset;
        this.givenOffset = givenOffset;
    }

    private static String getMessage(long expectedOffset, long givenOffset) {
        return String.format("Bad Offset. Expected %d, given %d.", expectedOffset, givenOffset);
    }

    @SuppressFBWarnings(justification="generated code")
    public long getExpectedOffset() {
        return this.expectedOffset;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getGivenOffset() {
        return this.givenOffset;
    }
}

