/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.contracts;

import com.google.common.annotations.VisibleForTesting;
import io.pravega.common.io.StreamHelpers;
import io.pravega.segmentstore.contracts.ReadResultEntry;
import io.pravega.segmentstore.contracts.ReadResultEntryContents;
import io.pravega.segmentstore.contracts.ReadResultEntryType;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public interface ReadResult
extends Iterator<ReadResultEntry>,
AutoCloseable {
    public long getStreamSegmentStartOffset();

    public int getMaxResultLength();

    public int getConsumedLength();

    public boolean isClosed();

    @Override
    public void close();

    @VisibleForTesting
    default public int readRemaining(byte[] target, Duration fetchTimeout) {
        ReadResultEntry entry;
        int bytesRead;
        ReadResultEntryContents contents;
        for (bytesRead = 0; this.hasNext() && bytesRead < target.length && (entry = (ReadResultEntry)this.next()).getType() != ReadResultEntryType.EndOfStreamSegment && entry.getType() != ReadResultEntryType.Future; bytesRead += contents.getLength()) {
            if (!entry.getContent().isDone()) {
                entry.requestContent(fetchTimeout);
            }
            contents = entry.getContent().join();
            StreamHelpers.readAll((InputStream)contents.getData(), (byte[])target, (int)bytesRead, (int)Math.min(contents.getLength(), target.length - bytesRead));
        }
        return bytesRead;
    }

    default public List<InputStream> readRemaining(int maxLength, Duration fetchTimeout) {
        ReadResultEntry entry;
        int bytesRead = 0;
        ArrayList<InputStream> result = new ArrayList<InputStream>();
        while (this.hasNext() && bytesRead < maxLength && (entry = (ReadResultEntry)this.next()).getType() != ReadResultEntryType.EndOfStreamSegment && entry.getType() != ReadResultEntryType.Future) {
            if (!entry.getContent().isDone()) {
                entry.requestContent(fetchTimeout);
            }
            result.add(entry.getContent().join().getData());
        }
        return result;
    }
}

