/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.contracts.tables;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.HashedArray;
import io.pravega.segmentstore.contracts.tables.TableKey;
import java.beans.ConstructorProperties;
import lombok.NonNull;

public class TableEntry {
    private final TableKey key;
    private final ArrayView value;

    public static TableEntry unversioned(@NonNull ArrayView key, @NonNull ArrayView value) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked @NonNull but is null");
        }
        return new TableEntry(TableKey.unversioned(key), value);
    }

    public static TableEntry notExists(@NonNull ArrayView key, @NonNull ArrayView value) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked @NonNull but is null");
        }
        return new TableEntry(TableKey.notExists(key), value);
    }

    public static TableEntry notExists(@NonNull ArrayView key) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        return new TableEntry(TableKey.notExists(key), null);
    }

    public static TableEntry versioned(@NonNull ArrayView key, @NonNull ArrayView value, long version) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked @NonNull but is null");
        }
        return new TableEntry(TableKey.versioned(key, version), value);
    }

    public String toString() {
        return String.format("%s -> %s", this.key, this.value);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TableEntry) {
            TableEntry other = (TableEntry)obj;
            return this.key.equals(other.key) && (this.value == null && other.value == null || this.value != null && other.value != null && HashedArray.arrayEquals((ArrayView)this.value, (ArrayView)other.getValue()));
        }
        return false;
    }

    @SuppressFBWarnings(justification="generated code")
    public TableKey getKey() {
        return this.key;
    }

    @SuppressFBWarnings(justification="generated code")
    public ArrayView getValue() {
        return this.value;
    }

    @ConstructorProperties(value={"key", "value"})
    @SuppressFBWarnings(justification="generated code")
    private TableEntry(TableKey key, ArrayView value) {
        this.key = key;
        this.value = value;
    }
}

