/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.storage.ConfigSetup;
import io.pravega.segmentstore.storage.StorageFactory;
import io.pravega.segmentstore.storage.StorageFactoryCreator;
import java.util.ServiceLoader;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageLoader {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(StorageLoader.class);

    public StorageFactory load(ConfigSetup setup, String storageImplementation, ScheduledExecutorService executor) {
        ServiceLoader<StorageFactoryCreator> loader = ServiceLoader.load(StorageFactoryCreator.class);
        for (StorageFactoryCreator factory : loader) {
            log.info("Loading {}, trying {}", (Object)storageImplementation, (Object)factory.getName());
            if (!factory.getName().equals(storageImplementation)) continue;
            return factory.createFactory(setup, executor);
        }
        return null;
    }
}

