/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.LoggerHelpers;
import io.pravega.common.cluster.Cluster;
import io.pravega.common.cluster.Host;
import io.pravega.common.cluster.zkImpl.ClusterZKImpl;
import io.pravega.segmentstore.server.SegmentContainerManager;
import io.pravega.segmentstore.server.SegmentContainerRegistry;
import io.pravega.segmentstore.server.host.ZKSegmentContainerMonitor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZKSegmentContainerManager
implements SegmentContainerManager {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(ZKSegmentContainerManager.class);
    private final Host host;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Cluster cluster;
    private final ZKSegmentContainerMonitor containerMonitor;

    ZKSegmentContainerManager(SegmentContainerRegistry containerRegistry, CuratorFramework zkClient, Host pravegaServiceEndpoint, ScheduledExecutorService executor) {
        Preconditions.checkNotNull((Object)containerRegistry, (Object)"containerRegistry");
        Preconditions.checkNotNull((Object)zkClient, (Object)"zkClient");
        this.host = (Host)Preconditions.checkNotNull((Object)pravegaServiceEndpoint, (Object)"pravegaServiceEndpoint");
        this.cluster = new ClusterZKImpl(zkClient, "hosts");
        this.containerMonitor = new ZKSegmentContainerMonitor(containerRegistry, zkClient, pravegaServiceEndpoint, executor);
    }

    public void initialize() {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"initialize", (Object[])new Object[0]);
        try {
            this.containerMonitor.initialize();
            this.cluster.registerHost(this.host);
            log.info("Initialized.");
            LoggerHelpers.traceLeave((Logger)log, (String)"initialize", (long)traceId, (Object[])new Object[0]);
        }
        catch (Exception ex) {
            log.error("Initialization error. Cleaning up.", (Throwable)ex);
            this.close();
            throw ex;
        }
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.close(this.containerMonitor);
            this.close((AutoCloseable)this.cluster);
        }
    }

    private void close(AutoCloseable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Exception e) {
            log.error("Error while closing resource", (Throwable)e);
        }
    }
}

