/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host.handler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.GenericFutureListener;
import io.pravega.common.Exceptions;
import io.pravega.segmentstore.server.IllegalContainerStateException;
import io.pravega.segmentstore.server.host.handler.ServerConnection;
import io.pravega.shared.protocol.netty.Request;
import io.pravega.shared.protocol.netty.RequestProcessor;
import io.pravega.shared.protocol.netty.WireCommand;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConnectionInboundHandler
extends ChannelInboundHandlerAdapter
implements ServerConnection {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(ServerConnectionInboundHandler.class);
    private AtomicReference<RequestProcessor> processor = new AtomicReference();
    private AtomicReference<Channel> channel = new AtomicReference();

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
        this.channel.set(ctx.channel());
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Request cmd = (Request)msg;
        if (cmd.mustLog()) {
            log.debug("Received request: {}", (Object)cmd);
        } else {
            log.trace("Received request: {}", (Object)cmd);
        }
        RequestProcessor requestProcessor = this.processor.get();
        if (requestProcessor == null) {
            throw new IllegalStateException("No command processor set for connection");
        }
        cmd.process(requestProcessor);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.logError(cause);
        ctx.close();
    }

    @Override
    public void send(WireCommand cmd) {
        Channel c = this.getChannel();
        EventLoop eventLoop = c.eventLoop();
        if (eventLoop.inEventLoop()) {
            eventLoop.execute(() -> ServerConnectionInboundHandler.writeAndFlush(c, cmd));
        } else {
            ServerConnectionInboundHandler.writeAndFlush(c, cmd);
        }
    }

    private static void writeAndFlush(Channel channel, WireCommand data) {
        channel.writeAndFlush((Object)data).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    @Override
    public void setRequestProcessor(RequestProcessor rp) {
        this.processor.set(rp);
    }

    @Override
    public void close() {
        Channel ch = this.channel.get();
        if (ch != null) {
            ch.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    @Override
    public void pauseReading() {
        this.getChannel().config().setAutoRead(false);
    }

    @Override
    public void resumeReading() {
        this.getChannel().config().setAutoRead(true);
    }

    private Channel getChannel() {
        Channel ch = this.channel.get();
        if (ch == null) {
            throw new IllegalStateException("Connection not yet established.");
        }
        return ch;
    }

    private void logError(Throwable cause) {
        if (Exceptions.unwrap((Throwable)cause) instanceof IllegalContainerStateException) {
            log.warn("Caught exception on connection: {}", (Object)cause.toString());
        } else {
            log.error("Caught exception on connection: ", cause);
        }
    }

    public String toString() {
        Channel c = this.channel.get();
        if (c == null) {
            return "NewServerConnection";
        }
        return c.toString();
    }
}

