/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host.security;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.handler.ssl.SslContext;
import io.pravega.segmentstore.server.host.security.TLSConfigChangeHandler;
import java.nio.file.WatchEvent;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLSConfigChangeEventConsumer
implements Consumer<WatchEvent<?>> {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(TLSConfigChangeEventConsumer.class);
    private final TLSConfigChangeHandler handler;

    public TLSConfigChangeEventConsumer(AtomicReference<SslContext> sslContext, String pathToCertificateFile, String pathToKeyFile) {
        this.handler = new TLSConfigChangeHandler(sslContext, pathToCertificateFile, pathToKeyFile);
    }

    @Override
    public void accept(WatchEvent<?> watchEvent) {
        if (watchEvent != null) {
            log.info("Invoked for [{}]", watchEvent.context());
        } else {
            log.warn("Invoked for null watchEvent");
        }
        this.handler.handleTlsConfigChange();
    }

    @VisibleForTesting
    int getNumOfConfigChangesSinceStart() {
        return this.handler.getNumOfConfigChangesSinceStart();
    }
}

