/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host.security;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.handler.ssl.SslContext;
import io.pravega.segmentstore.server.host.security.TLSHelper;
import java.beans.ConstructorProperties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TLSConfigChangeHandler {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(TLSConfigChangeHandler.class);
    private final AtomicInteger numOfConfigChangesSinceStart = new AtomicInteger(0);
    @NonNull
    private final AtomicReference<SslContext> sslContext;
    @NonNull
    private final String pathToCertificateFile;
    @NonNull
    private final String pathToKeyFile;

    public void handleTlsConfigChange() {
        log.info("Current reload count = {}", (Object)this.numOfConfigChangesSinceStart.incrementAndGet());
        this.sslContext.set(TLSHelper.newServerSslContext(this.pathToCertificateFile, this.pathToKeyFile));
    }

    int getNumOfConfigChangesSinceStart() {
        return this.numOfConfigChangesSinceStart.get();
    }

    @ConstructorProperties(value={"sslContext", "pathToCertificateFile", "pathToKeyFile"})
    @SuppressFBWarnings(justification="generated code")
    public TLSConfigChangeHandler(@NonNull AtomicReference<SslContext> sslContext, @NonNull String pathToCertificateFile, @NonNull String pathToKeyFile) {
        if (sslContext == null) {
            throw new NullPointerException("sslContext is marked @NonNull but is null");
        }
        if (pathToCertificateFile == null) {
            throw new NullPointerException("pathToCertificateFile is marked @NonNull but is null");
        }
        if (pathToKeyFile == null) {
            throw new NullPointerException("pathToKeyFile is marked @NonNull but is null");
        }
        this.sslContext = sslContext;
        this.pathToCertificateFile = pathToCertificateFile;
        this.pathToKeyFile = pathToKeyFile;
    }
}

