/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host.stat;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.server.host.stat.TableSegmentStatsRecorder;
import io.pravega.shared.MetricsNames;
import io.pravega.shared.MetricsTags;
import io.pravega.shared.metrics.DynamicLogger;
import io.pravega.shared.metrics.MetricsProvider;
import io.pravega.shared.metrics.OpStatsLogger;
import io.pravega.shared.metrics.StatsLogger;
import java.time.Duration;

public class TableSegmentStatsRecorderImpl
implements TableSegmentStatsRecorder {
    private static final StatsLogger STATS_LOGGER = MetricsProvider.createStatsLogger((String)"segmentstore");
    private final OpStatsLogger createSegment = this.createLogger("pravega.segmentstore.segment.create_latency_ms");
    private final OpStatsLogger deleteSegment = this.createLogger("pravega.segmentstore.segment.delete_latency_ms");
    private final OpStatsLogger updateConditional = this.createLogger("pravega.segmentstore.tablesegment.update_conditional_latency_ms");
    private final OpStatsLogger updateUnconditional = this.createLogger("pravega.segmentstore.tablesegment.update_latency_ms");
    private final OpStatsLogger removeConditional = this.createLogger("pravega.segmentstore.tablesegment.remove_conditional_latency_ms");
    private final OpStatsLogger removeUnconditional = this.createLogger("pravega.segmentstore.tablesegment.remove_latency_ms");
    private final OpStatsLogger getKeys = this.createLogger("pravega.segmentstore.tablesegment.get_latency_ms");
    private final OpStatsLogger iterateKeys = this.createLogger("pravega.segmentstore.tablesegment.iterate_keys_latency_ms");
    private final OpStatsLogger iterateEntries = this.createLogger("pravega.segmentstore.tablesegment.iterate_entries_latency_ms");
    private final DynamicLogger dynamicLogger = this.createDynamicLogger();

    @Override
    public void close() {
        this.createSegment.close();
        this.deleteSegment.close();
        this.updateConditional.close();
        this.updateUnconditional.close();
        this.removeConditional.close();
        this.removeUnconditional.close();
        this.getKeys.close();
        this.iterateKeys.close();
        this.iterateEntries.close();
    }

    @Override
    public void createTableSegment(String tableSegmentName, Duration elapsed) {
        this.getCreateSegment().reportSuccessEvent(elapsed);
    }

    @Override
    public void deleteTableSegment(String tableSegmentName, Duration elapsed) {
        this.getDeleteSegment().reportSuccessEvent(elapsed);
        String[] segmentTags = MetricsTags.segmentTags((String)tableSegmentName);
        this.getDynamicLogger().freezeCounter("pravega.segmentstore.tablesegment.update_conditional", segmentTags);
        this.getDynamicLogger().freezeCounter("pravega.segmentstore.tablesegment.update", segmentTags);
        this.getDynamicLogger().freezeCounter("pravega.segmentstore.tablesegment.remove_conditional", segmentTags);
        this.getDynamicLogger().freezeCounter("pravega.segmentstore.tablesegment.remove", segmentTags);
        this.getDynamicLogger().freezeCounter("pravega.segmentstore.tablesegment.get", segmentTags);
        this.getDynamicLogger().freezeCounter("pravega.segmentstore.tablesegment.iterate_keys", segmentTags);
        this.getDynamicLogger().freezeCounter("pravega.segmentstore.tablesegment.iterate_entries", segmentTags);
    }

    @Override
    public void updateEntries(String tableSegmentName, int entryCount, boolean conditional, Duration elapsed) {
        this.choose(conditional, this.getUpdateConditional(), this.getUpdateUnconditional()).reportSuccessEvent(elapsed);
        String countMetric = this.choose(conditional, "pravega.segmentstore.tablesegment.update_conditional", "pravega.segmentstore.tablesegment.update");
        this.getDynamicLogger().incCounterValue(MetricsNames.globalMetricName((String)countMetric), (long)entryCount, new String[0]);
        this.getDynamicLogger().incCounterValue(countMetric, (long)entryCount, MetricsTags.segmentTags((String)tableSegmentName));
    }

    @Override
    public void removeKeys(String tableSegmentName, int keyCount, boolean conditional, Duration elapsed) {
        this.choose(conditional, this.getRemoveConditional(), this.getRemoveUnconditional()).reportSuccessEvent(elapsed);
        String countMetric = this.choose(conditional, "pravega.segmentstore.tablesegment.remove_conditional", "pravega.segmentstore.tablesegment.remove");
        this.getDynamicLogger().incCounterValue(MetricsNames.globalMetricName((String)countMetric), (long)keyCount, new String[0]);
        this.getDynamicLogger().incCounterValue(countMetric, (long)keyCount, MetricsTags.segmentTags((String)tableSegmentName));
    }

    @Override
    public void getKeys(String tableSegmentName, int keyCount, Duration elapsed) {
        this.getGetKeys().reportSuccessEvent(elapsed);
        this.getDynamicLogger().incCounterValue(MetricsNames.globalMetricName((String)"pravega.segmentstore.tablesegment.get"), (long)keyCount, new String[0]);
        this.getDynamicLogger().incCounterValue("pravega.segmentstore.tablesegment.get", (long)keyCount, MetricsTags.segmentTags((String)tableSegmentName));
    }

    @Override
    public void iterateKeys(String tableSegmentName, int resultCount, Duration elapsed) {
        this.getIterateKeys().reportSuccessEvent(elapsed);
        this.getDynamicLogger().incCounterValue(MetricsNames.globalMetricName((String)"pravega.segmentstore.tablesegment.iterate_keys"), (long)resultCount, new String[0]);
        this.getDynamicLogger().incCounterValue("pravega.segmentstore.tablesegment.iterate_keys", (long)resultCount, MetricsTags.segmentTags((String)tableSegmentName));
    }

    @Override
    public void iterateEntries(String tableSegmentName, int resultCount, Duration elapsed) {
        this.getIterateEntries().reportSuccessEvent(elapsed);
        this.getDynamicLogger().incCounterValue(MetricsNames.globalMetricName((String)"pravega.segmentstore.tablesegment.iterate_entries"), (long)resultCount, new String[0]);
        this.getDynamicLogger().incCounterValue("pravega.segmentstore.tablesegment.iterate_entries", (long)resultCount, MetricsTags.segmentTags((String)tableSegmentName));
    }

    protected OpStatsLogger createLogger(String name) {
        return STATS_LOGGER.createStats(name, new String[0]);
    }

    protected DynamicLogger createDynamicLogger() {
        return MetricsProvider.getDynamicLogger();
    }

    private <T> T choose(boolean conditional, T whenConditional, T whenUnconditional) {
        return conditional ? whenConditional : whenUnconditional;
    }

    @SuppressFBWarnings(justification="generated code")
    OpStatsLogger getCreateSegment() {
        return this.createSegment;
    }

    @SuppressFBWarnings(justification="generated code")
    OpStatsLogger getDeleteSegment() {
        return this.deleteSegment;
    }

    @SuppressFBWarnings(justification="generated code")
    OpStatsLogger getUpdateConditional() {
        return this.updateConditional;
    }

    @SuppressFBWarnings(justification="generated code")
    OpStatsLogger getUpdateUnconditional() {
        return this.updateUnconditional;
    }

    @SuppressFBWarnings(justification="generated code")
    OpStatsLogger getRemoveConditional() {
        return this.removeConditional;
    }

    @SuppressFBWarnings(justification="generated code")
    OpStatsLogger getRemoveUnconditional() {
        return this.removeUnconditional;
    }

    @SuppressFBWarnings(justification="generated code")
    OpStatsLogger getGetKeys() {
        return this.getKeys;
    }

    @SuppressFBWarnings(justification="generated code")
    OpStatsLogger getIterateKeys() {
        return this.iterateKeys;
    }

    @SuppressFBWarnings(justification="generated code")
    OpStatsLogger getIterateEntries() {
        return this.iterateEntries;
    }

    @SuppressFBWarnings(justification="generated code")
    DynamicLogger getDynamicLogger() {
        return this.dynamicLogger;
    }
}

