/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.storage.filesystem;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.LoggerHelpers;
import io.pravega.common.Timer;
import io.pravega.common.util.ImmutableDate;
import io.pravega.segmentstore.contracts.BadOffsetException;
import io.pravega.segmentstore.contracts.SegmentProperties;
import io.pravega.segmentstore.contracts.StreamSegmentException;
import io.pravega.segmentstore.contracts.StreamSegmentExistsException;
import io.pravega.segmentstore.contracts.StreamSegmentInformation;
import io.pravega.segmentstore.contracts.StreamSegmentNotExistsException;
import io.pravega.segmentstore.contracts.StreamSegmentSealedException;
import io.pravega.segmentstore.storage.SegmentHandle;
import io.pravega.segmentstore.storage.SyncStorage;
import io.pravega.storage.filesystem.FileSystemMetrics;
import io.pravega.storage.filesystem.FileSystemSegmentHandle;
import io.pravega.storage.filesystem.FileSystemStorageConfig;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.AccessControlException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemStorage
implements SyncStorage {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(FileSystemStorage.class);
    private static final Set<PosixFilePermission> READ_ONLY_PERMISSION = ImmutableSet.of((Object)((Object)PosixFilePermission.OWNER_READ), (Object)((Object)PosixFilePermission.GROUP_READ), (Object)((Object)PosixFilePermission.OTHERS_READ));
    private static final Set<PosixFilePermission> READ_WRITE_PERMISSION = ImmutableSet.of((Object)((Object)PosixFilePermission.OWNER_WRITE), (Object)((Object)PosixFilePermission.OWNER_READ), (Object)((Object)PosixFilePermission.GROUP_READ), (Object)((Object)PosixFilePermission.OTHERS_READ));
    private final FileSystemStorageConfig config;
    private final AtomicBoolean closed;

    public FileSystemStorage(FileSystemStorageConfig config) {
        this.config = (FileSystemStorageConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.closed = new AtomicBoolean(false);
    }

    public void initialize(long containerEpoch) {
    }

    public SegmentHandle openRead(String streamSegmentName) throws StreamSegmentException {
        return this.execute(streamSegmentName, () -> this.doOpenRead(streamSegmentName));
    }

    public int read(SegmentHandle handle, long offset, byte[] buffer, int bufferOffset, int length) throws StreamSegmentException {
        return this.execute(handle.getSegmentName(), () -> this.doRead(handle, offset, buffer, bufferOffset, length));
    }

    public SegmentProperties getStreamSegmentInfo(String streamSegmentName) throws StreamSegmentException {
        return this.execute(streamSegmentName, () -> this.doGetStreamSegmentInfo(streamSegmentName));
    }

    public boolean exists(String streamSegmentName) {
        return this.execute(streamSegmentName, () -> this.doExists(streamSegmentName));
    }

    public SegmentHandle openWrite(String streamSegmentName) throws StreamSegmentException {
        return this.execute(streamSegmentName, () -> this.doOpenWrite(streamSegmentName));
    }

    public SegmentHandle create(String streamSegmentName) throws StreamSegmentException {
        return this.execute(streamSegmentName, () -> this.doCreate(streamSegmentName));
    }

    public void write(SegmentHandle handle, long offset, InputStream data, int length) throws StreamSegmentException {
        this.execute(handle.getSegmentName(), () -> this.doWrite(handle, offset, data, length));
    }

    public void seal(SegmentHandle handle) throws StreamSegmentException {
        this.execute(handle.getSegmentName(), () -> this.doSeal(handle));
    }

    public void unseal(SegmentHandle handle) throws StreamSegmentException {
        this.execute(handle.getSegmentName(), () -> this.doUnseal(handle));
    }

    public void concat(SegmentHandle targetHandle, long offset, String sourceSegment) throws StreamSegmentException {
        this.execute(targetHandle.getSegmentName(), () -> this.doConcat(targetHandle, offset, sourceSegment));
    }

    public void delete(SegmentHandle handle) throws StreamSegmentException {
        this.execute(handle.getSegmentName(), () -> this.doDelete(handle));
    }

    public void truncate(SegmentHandle handle, long offset) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support Segment truncation.");
    }

    public boolean supportsTruncation() {
        return false;
    }

    public void close() {
        this.closed.set(true);
    }

    private SegmentHandle doOpenRead(String streamSegmentName) throws StreamSegmentNotExistsException {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"openRead", (Object[])new Object[]{streamSegmentName});
        Path path = Paths.get(this.config.getRoot(), streamSegmentName);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new StreamSegmentNotExistsException(streamSegmentName);
        }
        LoggerHelpers.traceLeave((Logger)log, (String)"openRead", (long)traceId, (Object[])new Object[]{streamSegmentName});
        return FileSystemSegmentHandle.readHandle(streamSegmentName);
    }

    private SegmentHandle doOpenWrite(String streamSegmentName) throws StreamSegmentNotExistsException {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"openWrite", (Object[])new Object[]{streamSegmentName});
        Path path = Paths.get(this.config.getRoot(), streamSegmentName);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new StreamSegmentNotExistsException(streamSegmentName);
        }
        if (Files.isWritable(path)) {
            LoggerHelpers.traceLeave((Logger)log, (String)"openWrite", (long)traceId, (Object[])new Object[0]);
            return FileSystemSegmentHandle.writeHandle(streamSegmentName);
        }
        LoggerHelpers.traceLeave((Logger)log, (String)"openWrite", (long)traceId, (Object[])new Object[0]);
        return FileSystemSegmentHandle.readHandle(streamSegmentName);
    }

    private int doRead(SegmentHandle handle, long offset, byte[] buffer, int bufferOffset, int length) throws IOException {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"read", (Object[])new Object[]{handle.getSegmentName(), offset, bufferOffset, length});
        Timer timer = new Timer();
        Path path = Paths.get(this.config.getRoot(), handle.getSegmentName());
        long fileSize = Files.size(path);
        if (fileSize < offset) {
            throw new IllegalArgumentException(String.format("Reading at offset (%d) which is beyond the current size of segment (%d).", offset, fileSize));
        }
        try (FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);){
            int bytesRead;
            int totalBytesRead = 0;
            do {
                ByteBuffer readBuffer = ByteBuffer.wrap(buffer, bufferOffset, length);
                bytesRead = channel.read(readBuffer, offset);
                bufferOffset += bytesRead;
                totalBytesRead += bytesRead;
            } while ((length -= bytesRead) != 0);
            FileSystemMetrics.READ_LATENCY.reportSuccessEvent(timer.getElapsed());
            FileSystemMetrics.READ_BYTES.add((long)totalBytesRead);
            LoggerHelpers.traceLeave((Logger)log, (String)"read", (long)traceId, (Object[])new Object[]{totalBytesRead});
            int n = totalBytesRead;
            return n;
        }
    }

    private SegmentProperties doGetStreamSegmentInfo(String streamSegmentName) throws IOException {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"getStreamSegmentInfo", (Object[])new Object[]{streamSegmentName});
        PosixFileAttributes attrs = Files.readAttributes(Paths.get(this.config.getRoot(), streamSegmentName), PosixFileAttributes.class, new LinkOption[0]);
        StreamSegmentInformation information = StreamSegmentInformation.builder().name(streamSegmentName).length(attrs.size()).sealed(!attrs.permissions().contains((Object)PosixFilePermission.OWNER_WRITE)).lastModified(new ImmutableDate(attrs.creationTime().toMillis())).build();
        LoggerHelpers.traceLeave((Logger)log, (String)"getStreamSegmentInfo", (long)traceId, (Object[])new Object[]{streamSegmentName});
        return information;
    }

    private boolean doExists(String streamSegmentName) {
        return Files.exists(Paths.get(this.config.getRoot(), streamSegmentName), new LinkOption[0]);
    }

    private SegmentHandle doCreate(String streamSegmentName) throws IOException {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"create", (Object[])new Object[]{streamSegmentName});
        FileAttribute<Set<PosixFilePermission>> fileAttributes = PosixFilePermissions.asFileAttribute(READ_WRITE_PERMISSION);
        Path path = Paths.get(this.config.getRoot(), streamSegmentName);
        Path parent = path.getParent();
        assert (parent != null);
        Files.createDirectories(parent, new FileAttribute[0]);
        Files.createFile(path, fileAttributes);
        LoggerHelpers.traceLeave((Logger)log, (String)"create", (long)traceId, (Object[])new Object[0]);
        FileSystemMetrics.CREATE_COUNT.inc();
        return FileSystemSegmentHandle.writeHandle(streamSegmentName);
    }

    private Void doWrite(SegmentHandle handle, long offset, InputStream data, int length) throws Exception {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"write", (Object[])new Object[]{handle.getSegmentName(), offset, length});
        Timer timer = new Timer();
        if (handle.isReadOnly()) {
            throw new IllegalArgumentException("Write called on a readonly handle of segment " + handle.getSegmentName());
        }
        Path path = Paths.get(this.config.getRoot(), handle.getSegmentName());
        if (!this.isWritableFile(path)) {
            throw new StreamSegmentSealedException(handle.getSegmentName());
        }
        long totalBytesWritten = 0L;
        try (FileChannel channel = FileChannel.open(path, StandardOpenOption.WRITE);){
            long fileSize = channel.size();
            if (fileSize != offset) {
                throw new BadOffsetException(handle.getSegmentName(), fileSize, offset);
            }
            ReadableByteChannel sourceChannel = Channels.newChannel(data);
            while (length != 0) {
                long bytesWritten = channel.transferFrom(sourceChannel, offset, length);
                assert (bytesWritten > 0L) : "Unable to make any progress transferring data.";
                offset += bytesWritten;
                totalBytesWritten += bytesWritten;
                length = (int)((long)length - bytesWritten);
            }
            channel.force(false);
        }
        FileSystemMetrics.WRITE_LATENCY.reportSuccessEvent(timer.getElapsed());
        FileSystemMetrics.WRITE_BYTES.add(totalBytesWritten);
        LoggerHelpers.traceLeave((Logger)log, (String)"write", (long)traceId, (Object[])new Object[0]);
        return null;
    }

    private boolean isWritableFile(Path path) throws IOException {
        PosixFileAttributes attrs = Files.readAttributes(path, PosixFileAttributes.class, new LinkOption[0]);
        return attrs.permissions().contains((Object)PosixFilePermission.OWNER_WRITE);
    }

    private Void doSeal(SegmentHandle handle) throws IOException {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"seal", (Object[])new Object[]{handle.getSegmentName()});
        if (handle.isReadOnly()) {
            throw new IllegalArgumentException(handle.getSegmentName());
        }
        Files.setPosixFilePermissions(Paths.get(this.config.getRoot(), handle.getSegmentName()), READ_ONLY_PERMISSION);
        LoggerHelpers.traceLeave((Logger)log, (String)"seal", (long)traceId, (Object[])new Object[0]);
        return null;
    }

    private Void doUnseal(SegmentHandle handle) throws IOException {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"unseal", (Object[])new Object[]{handle.getSegmentName()});
        Files.setPosixFilePermissions(Paths.get(this.config.getRoot(), handle.getSegmentName()), READ_WRITE_PERMISSION);
        LoggerHelpers.traceLeave((Logger)log, (String)"unseal", (long)traceId, (Object[])new Object[0]);
        return null;
    }

    /*
     * Exception decompiling
     */
    private Void doConcat(SegmentHandle targetHandle, long offset, String sourceSegment) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Void doDelete(SegmentHandle handle) throws IOException {
        Files.delete(Paths.get(this.config.getRoot(), handle.getSegmentName()));
        return null;
    }

    private <R> R execute(String segmentName, Callable<R> operation) throws StreamSegmentException {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        try {
            return operation.call();
        }
        catch (Exception e) {
            return (R)this.throwException(segmentName, e);
        }
    }

    private <T> T throwException(String segmentName, Exception e) throws StreamSegmentException {
        if (e instanceof NoSuchFileException || e instanceof FileNotFoundException) {
            throw new StreamSegmentNotExistsException(segmentName);
        }
        if (e instanceof FileAlreadyExistsException) {
            throw new StreamSegmentExistsException(segmentName);
        }
        if (e instanceof IndexOutOfBoundsException) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (e instanceof AccessControlException || e instanceof AccessDeniedException || e instanceof NonWritableChannelException) {
            throw new StreamSegmentSealedException(segmentName, (Throwable)e);
        }
        throw Exceptions.sneakyThrow((Throwable)e);
    }
}

