/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.storage.filesystem;

import com.google.common.base.Preconditions;
import io.pravega.segmentstore.storage.AsyncStorageWrapper;
import io.pravega.segmentstore.storage.Storage;
import io.pravega.segmentstore.storage.StorageFactory;
import io.pravega.segmentstore.storage.SyncStorage;
import io.pravega.segmentstore.storage.rolling.RollingStorage;
import io.pravega.storage.filesystem.FileSystemStorage;
import io.pravega.storage.filesystem.FileSystemStorageConfig;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public class FileSystemStorageFactory
implements StorageFactory {
    private final FileSystemStorageConfig config;
    private final ExecutorService executor;

    public FileSystemStorageFactory(FileSystemStorageConfig config, ExecutorService executor) {
        Preconditions.checkNotNull((Object)config, (Object)"config");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.config = config;
        this.executor = executor;
    }

    public Storage createStorageAdapter() {
        FileSystemStorage s = new FileSystemStorage(this.config);
        return new AsyncStorageWrapper((SyncStorage)new RollingStorage((SyncStorage)s), (Executor)this.executor);
    }
}

