/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host.delegationtoken;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.auth.AuthHandler;
import io.pravega.auth.InvalidClaimException;
import io.pravega.auth.InvalidTokenException;
import io.pravega.auth.TokenException;
import io.pravega.auth.TokenExpiredException;
import io.pravega.common.Exceptions;
import io.pravega.segmentstore.server.host.delegationtoken.DelegationTokenVerifier;
import io.pravega.segmentstore.server.host.stat.AutoScalerConfig;
import io.pravega.shared.security.token.JsonWebToken;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenVerifierImpl
implements DelegationTokenVerifier {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(TokenVerifierImpl.class);
    private final boolean isAuthEnabled;
    private final byte[] tokenSigningKey;

    public TokenVerifierImpl(AutoScalerConfig config) {
        this(config.isAuthEnabled(), config.getTokenSigningKey());
    }

    @VisibleForTesting
    public TokenVerifierImpl(boolean isAuthEnabled, String tokenSigningKeyBasis) {
        this.isAuthEnabled = isAuthEnabled;
        if (isAuthEnabled) {
            Exceptions.checkNotNullOrEmpty((String)tokenSigningKeyBasis, (String)"tokenSigningKeyBasis");
            this.tokenSigningKey = tokenSigningKeyBasis.getBytes();
        } else {
            this.tokenSigningKey = null;
        }
    }

    @Override
    public void verifyToken(String resource, String token, AuthHandler.Permissions expectedLevel) throws TokenExpiredException, InvalidTokenException, InvalidClaimException, TokenException {
        if (this.isAuthEnabled) {
            Set claims = JsonWebToken.fetchClaims((String)token, (byte[])this.tokenSigningKey);
            if (claims == null) {
                throw new InvalidTokenException("Token has no claims.");
            }
            Optional<Map.Entry> matchingClaim = claims.stream().filter(entry -> this.resourceMatchesClaimKey((String)entry.getKey(), resource) && expectedLevel.compareTo((Enum)AuthHandler.Permissions.valueOf((String)entry.getValue().toString())) <= 0).findFirst();
            if (!matchingClaim.isPresent()) {
                log.debug(String.format("No matching claim found for resource [%s] and permission [%s] in token [%s].", resource, expectedLevel, token));
                throw new InvalidClaimException(String.format("No matching claim found for resource: [%s] and permission: [%s] in the delegation token.", resource, expectedLevel));
            }
        }
    }

    private boolean resourceMatchesClaimKey(String claimKey, String resource) {
        return resource.equals(claimKey) || claimKey.endsWith("/") && resource.startsWith(claimKey) || resource.startsWith(claimKey + "/") || claimKey.equals("*");
    }
}

