/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host.handler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Slf4JLoggerFactory;
import io.pravega.common.Exceptions;
import io.pravega.common.io.filesystem.FileModificationEventWatcher;
import io.pravega.common.io.filesystem.FileModificationMonitor;
import io.pravega.common.io.filesystem.FileModificationPollingMonitor;
import io.pravega.segmentstore.contracts.StreamSegmentStore;
import io.pravega.segmentstore.contracts.tables.TableStore;
import io.pravega.segmentstore.server.host.delegationtoken.DelegationTokenVerifier;
import io.pravega.segmentstore.server.host.delegationtoken.PassingTokenVerifier;
import io.pravega.segmentstore.server.host.handler.AppendProcessor;
import io.pravega.segmentstore.server.host.handler.PravegaRequestProcessor;
import io.pravega.segmentstore.server.host.handler.ServerConnectionInboundHandler;
import io.pravega.segmentstore.server.host.security.TLSConfigChangeEventConsumer;
import io.pravega.segmentstore.server.host.security.TLSConfigChangeFileConsumer;
import io.pravega.segmentstore.server.host.security.TLSHelper;
import io.pravega.segmentstore.server.host.stat.SegmentStatsRecorder;
import io.pravega.segmentstore.server.host.stat.TableSegmentStatsRecorder;
import io.pravega.shared.metrics.MetricNotifier;
import io.pravega.shared.protocol.netty.AppendDecoder;
import io.pravega.shared.protocol.netty.CommandDecoder;
import io.pravega.shared.protocol.netty.CommandEncoder;
import io.pravega.shared.protocol.netty.ExceptionLoggingHandler;
import io.pravega.shared.protocol.netty.RequestProcessor;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PravegaConnectionListener
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(PravegaConnectionListener.class);
    private final String host;
    private final int port;
    private final StreamSegmentStore store;
    private final TableStore tableStore;
    private final DelegationTokenVerifier tokenVerifier;
    private Channel serverChannel;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private final SegmentStatsRecorder statsRecorder;
    private final TableSegmentStatsRecorder tableStatsRecorder;
    private final boolean replyWithStackTraceOnError;
    private final boolean enableTls;
    @VisibleForTesting
    private final boolean enableTlsReload;
    private final String pathToTlsCertFile;
    private final String pathToTlsKeyFile;
    private FileModificationMonitor tlsCertFileModificationMonitor;

    @VisibleForTesting
    public PravegaConnectionListener(boolean enableTls, int port, StreamSegmentStore streamSegmentStore, TableStore tableStore) {
        this(enableTls, false, "localhost", port, streamSegmentStore, tableStore, SegmentStatsRecorder.noOp(), TableSegmentStatsRecorder.noOp(), new PassingTokenVerifier(), null, null, true);
    }

    public PravegaConnectionListener(boolean enableTls, boolean enableTlsReload, String host, int port, StreamSegmentStore streamSegmentStore, TableStore tableStore, SegmentStatsRecorder statsRecorder, TableSegmentStatsRecorder tableStatsRecorder, DelegationTokenVerifier tokenVerifier, String certFile, String keyFile, boolean replyWithStackTraceOnError) {
        this.enableTls = enableTls;
        this.enableTlsReload = this.enableTls ? enableTlsReload : false;
        this.host = Exceptions.checkNotNullOrEmpty((String)host, (String)"host");
        this.port = port;
        this.store = (StreamSegmentStore)Preconditions.checkNotNull((Object)streamSegmentStore, (Object)"streamSegmentStore");
        this.tableStore = (TableStore)Preconditions.checkNotNull((Object)tableStore, (Object)"tableStore");
        this.statsRecorder = (SegmentStatsRecorder)Preconditions.checkNotNull((Object)statsRecorder, (Object)"statsRecorder");
        this.tableStatsRecorder = (TableSegmentStatsRecorder)Preconditions.checkNotNull((Object)tableStatsRecorder, (Object)"tableStatsRecorder");
        this.pathToTlsCertFile = certFile;
        this.pathToTlsKeyFile = keyFile;
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Slf4JLoggerFactory.INSTANCE);
        this.tokenVerifier = tokenVerifier != null ? tokenVerifier : new PassingTokenVerifier();
        this.replyWithStackTraceOnError = replyWithStackTraceOnError;
    }

    public void startListening() {
        final AtomicReference<SslContext> sslCtx = this.enableTls ? new AtomicReference<SslContext>(TLSHelper.newServerSslContext(this.pathToTlsCertFile, this.pathToTlsKeyFile)) : null;
        boolean nio = false;
        try {
            this.bossGroup = new EpollEventLoopGroup(1);
            this.workerGroup = new EpollEventLoopGroup();
        }
        catch (ExceptionInInitializerError | NoClassDefFoundError | UnsatisfiedLinkError e) {
            nio = true;
            this.bossGroup = new NioEventLoopGroup(1);
            this.workerGroup = new NioEventLoopGroup();
        }
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(nio ? NioServerSocketChannel.class : EpollServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                if (PravegaConnectionListener.this.enableTls) {
                    SslHandler sslHandler = ((SslContext)sslCtx.get()).newHandler(ch.alloc());
                    p.addLast("tls", (ChannelHandler)sslHandler);
                }
                ServerConnectionInboundHandler lsh = new ServerConnectionInboundHandler();
                p.addLast(new ChannelHandler[]{new ExceptionLoggingHandler(ch.remoteAddress().toString()), new CommandEncoder(null, MetricNotifier.NO_OP_METRIC_NOTIFIER), new LengthFieldBasedFrameDecoder(0x7FFFFF, 4, 4), new CommandDecoder(), new AppendDecoder(), lsh});
                lsh.setRequestProcessor((RequestProcessor)new AppendProcessor(PravegaConnectionListener.this.store, lsh, new PravegaRequestProcessor(PravegaConnectionListener.this.store, PravegaConnectionListener.this.tableStore, lsh, PravegaConnectionListener.this.statsRecorder, PravegaConnectionListener.this.tableStatsRecorder, PravegaConnectionListener.this.tokenVerifier, PravegaConnectionListener.this.replyWithStackTraceOnError), PravegaConnectionListener.this.statsRecorder, PravegaConnectionListener.this.tokenVerifier, PravegaConnectionListener.this.replyWithStackTraceOnError));
            }
        });
        if (this.enableTls && this.enableTlsReload) {
            this.enableTlsContextReload(sslCtx);
        }
        this.serverChannel = b.bind(this.host, this.port).awaitUninterruptibly().channel();
    }

    @VisibleForTesting
    void enableTlsContextReload(AtomicReference<SslContext> sslCtx) {
        this.tlsCertFileModificationMonitor = this.prepareCertificateMonitor(this.pathToTlsCertFile, this.pathToTlsKeyFile, sslCtx);
        this.tlsCertFileModificationMonitor.startMonitoring();
        log.info("Successfully started file modification monitoring for TLS certificate: [{}]", (Object)this.pathToTlsCertFile);
    }

    @VisibleForTesting
    FileModificationMonitor prepareCertificateMonitor(String tlsCertificatePath, String tlsKeyPath, AtomicReference<SslContext> sslCtx) {
        return this.prepareCertificateMonitor(Files.isSymbolicLink(Paths.get(tlsCertificatePath, new String[0])), tlsCertificatePath, tlsKeyPath, sslCtx);
    }

    @VisibleForTesting
    FileModificationMonitor prepareCertificateMonitor(boolean isTLSCertPathSymLink, String tlsCertificatePath, String tlsKeyPath, AtomicReference<SslContext> sslCtx) {
        try {
            FileModificationEventWatcher result;
            if (isTLSCertPathSymLink) {
                log.info("The path to certificate file [{}] was found to be a symbolic link,  so using [{}] to monitor for certificate changes", (Object)tlsCertificatePath, (Object)FileModificationPollingMonitor.class.getSimpleName());
                result = new FileModificationPollingMonitor(Paths.get(tlsCertificatePath, new String[0]), (Consumer)new TLSConfigChangeFileConsumer(sslCtx, tlsCertificatePath, tlsKeyPath));
            } else {
                result = new FileModificationEventWatcher(Paths.get(tlsCertificatePath, new String[0]), (Consumer)new TLSConfigChangeEventConsumer(sslCtx, tlsCertificatePath, tlsKeyPath));
            }
            return result;
        }
        catch (FileNotFoundException e) {
            log.error("Failed to prepare a monitor for the certificate at path [{}]", (Object)tlsCertificatePath, (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        Exceptions.handleInterrupted(() -> {
            if (this.serverChannel != null) {
                this.serverChannel.close();
                this.serverChannel.closeFuture().sync();
            }
        });
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
        }
        if (this.tlsCertFileModificationMonitor != null) {
            this.tlsCertFileModificationMonitor.stopMonitoring();
        }
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isEnableTlsReload() {
        return this.enableTlsReload;
    }
}

