/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host.stat;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.shared.segment.ScaleType;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
abstract class SegmentAggregates {
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int INTERVAL_IN_SECONDS = 5;
    private static final long TICK_INTERVAL = Duration.ofSeconds(5L).toMillis();
    private static final double M2_ALPHA = 1.0 - StrictMath.exp(-0.041666666666666664);
    private static final double M5_ALPHA = 1.0 - StrictMath.exp(-0.016666666666666666);
    private static final double M10_ALPHA = 1.0 - StrictMath.exp(-0.008333333333333333);
    private static final double M20_ALPHA = 1.0 - StrictMath.exp(-0.004166666666666667);
    private final AtomicLong lastReportedTime;
    @GuardedBy(value="this")
    private int targetRate;
    @GuardedBy(value="this")
    private double twoMinuteRate;
    @GuardedBy(value="this")
    private double fiveMinuteRate;
    @GuardedBy(value="this")
    private double tenMinuteRate;
    @GuardedBy(value="this")
    private double twentyMinuteRate;
    private final long startTime;
    @GuardedBy(value="this")
    private long lastTick;
    @GuardedBy(value="this")
    private long currentCount;

    @VisibleForTesting
    SegmentAggregates(int targetRate) {
        this.targetRate = targetRate;
        this.startTime = this.getTimeMillis();
        this.lastReportedTime = new AtomicLong(this.startTime);
        this.lastTick = this.startTime;
        this.currentCount = 0L;
        this.twoMinuteRate = 0.0;
        this.fiveMinuteRate = 0.0;
        this.tenMinuteRate = 0.0;
        this.twentyMinuteRate = 0.0;
    }

    static SegmentAggregates forPolicy(ScaleType scaleType, int targetRate) {
        switch (scaleType) {
            case EventRate: {
                return new ByEventCount(targetRate);
            }
            case Throughput: {
                return new ByThroughput(targetRate);
            }
        }
        return new Fixed(targetRate);
    }

    @VisibleForTesting
    protected long getTimeMillis() {
        return System.currentTimeMillis();
    }

    @VisibleForTesting
    synchronized long getCurrentCount() {
        return this.currentCount;
    }

    abstract ScaleType getScaleType();

    protected abstract long getUpdateCountDelta(long var1, int var3);

    protected abstract double getRate(double var1);

    boolean isScalingEnabled() {
        return true;
    }

    synchronized boolean update(long dataLength, int numOfEvents) {
        if (this.isScalingEnabled()) {
            this.currentCount += this.getUpdateCountDelta(dataLength, numOfEvents);
            long newTick = this.getTimeMillis();
            long age = newTick - this.lastTick;
            if (age > TICK_INTERVAL) {
                this.lastTick = newTick;
                long count = this.currentCount;
                this.currentCount = 0L;
                this.computeDecay(count, (double)Duration.ofMillis(age).toMillis() / 1000.0);
            }
            return true;
        }
        return false;
    }

    boolean updateTx(long dataSize, int numOfEvents, long txnCreationTime) {
        long durationInMillis = this.getTimeMillis() - txnCreationTime;
        if (durationInMillis < TICK_INTERVAL) {
            return this.update(dataSize, numOfEvents);
        }
        assert (durationInMillis > 0L);
        int amortizedNumOfEvents = (int)((long)numOfEvents * TICK_INTERVAL) / (int)durationInMillis;
        return this.update(dataSize * TICK_INTERVAL / durationInMillis, amortizedNumOfEvents);
    }

    @GuardedBy(value="this")
    private void computeDecay(long count, double duration) {
        this.twoMinuteRate = this.decayingRate(count, this.twoMinuteRate, M2_ALPHA, duration);
        this.fiveMinuteRate = this.decayingRate(count, this.fiveMinuteRate, M5_ALPHA, duration);
        this.tenMinuteRate = this.decayingRate(count, this.tenMinuteRate, M10_ALPHA, duration);
        this.twentyMinuteRate = this.decayingRate(count, this.twentyMinuteRate, M20_ALPHA, duration);
    }

    private double decayingRate(long count, double rate, double alpha, double interval) {
        double instantRate = (double)count / interval;
        if (rate == 0.0) {
            return instantRate;
        }
        return rate + alpha * (instantRate - rate);
    }

    synchronized int getTargetRate() {
        return this.targetRate;
    }

    synchronized void setTargetRate(int value) {
        this.targetRate = value;
    }

    synchronized double getTwoMinuteRate() {
        return this.getRate(this.twoMinuteRate);
    }

    synchronized double getFiveMinuteRate() {
        return this.getRate(this.fiveMinuteRate);
    }

    synchronized double getTenMinuteRate() {
        return this.getRate(this.tenMinuteRate);
    }

    synchronized double getTwentyMinuteRate() {
        return this.getRate(this.twentyMinuteRate);
    }

    boolean reportIfNeeded(Duration reportingDuration) {
        long newValue;
        long now = this.getTimeMillis();
        return now == (newValue = this.lastReportedTime.updateAndGet(prev -> {
            if (now - prev > reportingDuration.toMillis()) {
                return now;
            }
            return prev;
        }));
    }

    @SuppressFBWarnings(justification="generated code")
    public long getStartTime() {
        return this.startTime;
    }

    static class Fixed
    extends SegmentAggregates {
        Fixed(int targetRate) {
            super(targetRate);
        }

        @Override
        public ScaleType getScaleType() {
            return ScaleType.NoScaling;
        }

        @Override
        public boolean isScalingEnabled() {
            return false;
        }

        @Override
        protected long getUpdateCountDelta(long dataLength, int numOfEvents) {
            return 0L;
        }

        @Override
        protected double getRate(double rate) {
            return rate;
        }
    }

    static class ByEventCount
    extends SegmentAggregates {
        ByEventCount(int targetRate) {
            super(targetRate);
        }

        @Override
        public ScaleType getScaleType() {
            return ScaleType.EventRate;
        }

        @Override
        protected long getUpdateCountDelta(long dataLength, int numOfEvents) {
            return numOfEvents;
        }

        @Override
        protected double getRate(double rate) {
            return rate;
        }
    }

    static class ByThroughput
    extends SegmentAggregates {
        ByThroughput(int targetRate) {
            super(targetRate);
        }

        @Override
        public ScaleType getScaleType() {
            return ScaleType.Throughput;
        }

        @Override
        protected long getUpdateCountDelta(long dataLength, int numOfEvents) {
            return dataLength;
        }

        @Override
        protected double getRate(double rate) {
            return rate / 1024.0;
        }
    }
}

