/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicLong;

public class ExponentialMovingAverage {
    private final double newSampleWeight;
    private final AtomicLong valueEncodedAsLong;
    private final boolean logarithmicWeighting;

    public ExponentialMovingAverage(double initialValue, double newSampleWeight, boolean logarithmicWeighting) {
        Preconditions.checkArgument((newSampleWeight > 0.0 && newSampleWeight < 1.0 ? 1 : 0) != 0, (Object)"New sample weight must be between 0.0 and 1.0");
        this.newSampleWeight = newSampleWeight;
        this.logarithmicWeighting = logarithmicWeighting;
        double value = this.calculateLog(initialValue);
        this.valueEncodedAsLong = new AtomicLong(Double.doubleToLongBits(value));
    }

    public double getCurrentValue() {
        double result = Double.longBitsToDouble(this.valueEncodedAsLong.get());
        return this.calculateExponential(result);
    }

    public double addNewSample(double newSample) {
        double sample = this.calculateLog(newSample);
        return Double.longBitsToDouble(this.valueEncodedAsLong.updateAndGet(value -> Double.doubleToRawLongBits(sample * this.newSampleWeight + (1.0 - this.newSampleWeight) * Double.longBitsToDouble(value))));
    }

    private double calculateLog(double newSample) {
        if (!this.logarithmicWeighting) {
            return newSample;
        }
        return Math.signum(newSample) * Math.log1p(Math.abs(newSample));
    }

    private double calculateExponential(double result) {
        if (!this.logarithmicWeighting) {
            return result;
        }
        return Math.signum(result) * Math.expm1(Math.abs(result));
    }

    public String toString() {
        return Double.toString(this.getCurrentValue());
    }
}

