/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.function.Supplier;

public class TimeoutTimer {
    private final Supplier<Long> getNanos;
    private volatile Duration timeout;
    private volatile long initialNanos;

    public TimeoutTimer(Duration initialTimeout) {
        this(initialTimeout, System::nanoTime);
    }

    public TimeoutTimer(Duration initialTimeout, Supplier<Long> getNanos) {
        this.timeout = initialTimeout;
        this.getNanos = getNanos;
        this.initialNanos = getNanos.get();
    }

    public Duration getRemaining() {
        return this.timeout.minusNanos(this.getNanos.get() - this.initialNanos);
    }

    public boolean hasRemaining() {
        return this.getNanos.get() - this.initialNanos < this.timeout.toNanos();
    }

    public void reset(Duration timeout) {
        this.initialNanos = this.getNanos.get();
        this.timeout = timeout;
    }

    public void zero() {
        this.initialNanos = this.getNanos.get() - this.timeout.toNanos();
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "TimeoutTimer(timeout=" + this.timeout + ")";
    }
}

