/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.auth;

import io.pravega.common.auth.JKSHelper;

public class ZKTLSUtils {
    public static void setSecureZKClientProperties(String trustStorePath, String trustStorePassword) {
        System.setProperty("zookeeper.client.secure", "true");
        System.setProperty("zookeeper.clientCnxnSocket", "org.apache.zookeeper.ClientCnxnSocketNetty");
        System.setProperty("zookeeper.ssl.trustStore.location", trustStorePath);
        System.setProperty("zookeeper.ssl.trustStore.password", trustStorePassword);
    }

    public static void unsetSecureZKClientProperties() {
        System.clearProperty("zookeeper.client.secure");
        System.clearProperty("zookeeper.clientCnxnSocket");
        System.clearProperty("zookeeper.ssl.trustStore.location");
        System.clearProperty("zookeeper.ssl.trustStore.password");
    }

    public static void setSecureZKServerProperties(String keyStore, String keyStorePasswordPath, String trustStore, String trustStorePasswordPath) {
        System.setProperty("zookeeper.serverCnxnFactory", "org.apache.zookeeper.server.NettyServerCnxnFactory");
        System.setProperty("zookeeper.ssl.keyStore.location", keyStore);
        System.setProperty("zookeeper.ssl.keyStore.password", JKSHelper.loadPasswordFrom(keyStorePasswordPath));
        System.setProperty("zookeeper.ssl.trustStore.location", trustStore);
        System.setProperty("zookeeper.ssl.trustStore.password", JKSHelper.loadPasswordFrom(trustStorePasswordPath));
        System.setProperty("zookeeper.authProvider.x509", "org.apache.zookeeper.server.auth.X509AuthenticationProvider");
    }

    public static void unsetSecureZKServerProperties() {
        System.clearProperty("zookeeper.serverCnxnFactory");
        System.clearProperty("zookeeper.ssl.keyStore.location");
        System.clearProperty("zookeeper.ssl.keyStore.password");
        System.clearProperty("zookeeper.ssl.trustStore.location");
        System.clearProperty("zookeeper.ssl.trustStore.password");
        System.clearProperty("zookeeper.authProvider.x509");
    }
}

