/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.concurrent;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CancellationToken {
    public static final CancellationToken NONE = new NonCancellableToken();
    @GuardedBy(value="futures")
    private final Collection<CompletableFuture<?>> futures = new HashSet();
    @GuardedBy(value="futures")
    private boolean cancellationRequested;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void register(CompletableFuture<T> future) {
        if (future.isDone()) {
            return;
        }
        boolean autoCancel = false;
        Collection<CompletableFuture<?>> collection = this.futures;
        synchronized (collection) {
            Preconditions.checkNotNull(future, (Object)"future");
            if (this.cancellationRequested) {
                autoCancel = true;
            } else {
                this.futures.add(future);
            }
        }
        if (autoCancel) {
            future.cancel(true);
            return;
        }
        future.whenComplete((r, ex) -> {
            Collection<CompletableFuture<?>> collection = this.futures;
            synchronized (collection) {
                this.futures.remove(future);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestCancellation() {
        ArrayList toInvoke;
        Collection<CompletableFuture<?>> collection = this.futures;
        synchronized (collection) {
            this.cancellationRequested = true;
            toInvoke = new ArrayList(this.futures);
        }
        toInvoke.forEach(f -> f.cancel(true));
        collection = this.futures;
        synchronized (collection) {
            this.futures.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Collection<CompletableFuture<?>> collection = this.futures;
        synchronized (collection) {
            return "Cancelled = " + Boolean.toString(this.cancellationRequested);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isCancellationRequested() {
        return this.cancellationRequested;
    }

    private static final class NonCancellableToken
    extends CancellationToken {
        private NonCancellableToken() {
        }

        @Override
        public <T> void register(CompletableFuture<T> future) {
        }

        @Override
        public void requestCancellation() {
        }
    }
}

