/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.concurrent;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.function.Callbacks;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiKeyLatestItemSequentialProcessor<KeyType, ItemType> {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(MultiKeyLatestItemSequentialProcessor.class);
    private final ConcurrentHashMap<KeyType, ItemType> toProcessKVP = new ConcurrentHashMap();
    private final BiConsumer<KeyType, ItemType> processFunction;
    private final Executor executor;

    public MultiKeyLatestItemSequentialProcessor(BiConsumer<KeyType, ItemType> processFunction, Executor executor) {
        this.processFunction = (BiConsumer)Preconditions.checkNotNull(processFunction);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
    }

    public void updateItem(KeyType key, ItemType newItem) {
        Preconditions.checkNotNull(newItem);
        Preconditions.checkNotNull(key);
        if (this.toProcessKVP.put(key, newItem) == null) {
            this.executor.execute(() -> {
                Object item = newItem;
                Callbacks.invokeSafely(this.processFunction, key, item, ex1 -> log.error("Error while invoking updateItem with key {} ", key, ex1));
                while (!this.toProcessKVP.remove(key, item)) {
                    item = this.toProcessKVP.get(key);
                    Callbacks.invokeSafely(this.processFunction, key, item, ex -> log.error("Error while invoking updateItem with key {} ", key, ex));
                }
            });
        }
    }
}

