/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.ObjectClosedException;
import io.pravega.common.concurrent.Futures;
import java.beans.ConstructorProperties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import lombok.NonNull;

public class SequentialProcessor
implements AutoCloseable {
    @NonNull
    private final Executor executor;
    @GuardedBy(value="lock")
    private CompletableFuture<?> lastTask;
    @GuardedBy(value="lock")
    private boolean closed = false;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        CompletableFuture<?> toCancel = null;
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                toCancel = this.lastTask;
                this.lastTask = null;
                this.closed = true;
            }
        }
        if (toCancel != null) {
            toCancel.completeExceptionally(new ObjectClosedException(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ReturnType> CompletableFuture<ReturnType> add(Supplier<CompletableFuture<? extends ReturnType>> toRun) {
        CompletableFuture<?> existingTask;
        CompletableFuture result = new CompletableFuture();
        Object object = this.lock;
        synchronized (object) {
            Exceptions.checkNotClosed(this.closed, this);
            existingTask = this.lastTask;
            if (existingTask != null) {
                existingTask.whenCompleteAsync((r, ex) -> Futures.completeAfter(toRun, result), this.executor);
            }
            this.lastTask = result;
        }
        if (existingTask == null) {
            Futures.completeAfter(toRun, result);
        }
        result.whenComplete((r, ex) -> {
            Object object = this.lock;
            synchronized (object) {
                if (this.lastTask != null && this.lastTask.isDone()) {
                    this.lastTask = null;
                }
            }
        });
        return result;
    }

    @ConstructorProperties(value={"executor"})
    @SuppressFBWarnings(justification="generated code")
    public SequentialProcessor(@NonNull Executor executor) {
        if (executor == null) {
            throw new NullPointerException("executor is marked @NonNull but is null");
        }
        this.executor = executor;
    }
}

