/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.io;

import com.google.common.base.Preconditions;
import io.pravega.common.Exceptions;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class StreamHelpers {
    public static int readAll(InputStream stream, byte[] target, int startOffset, int maxLength) throws IOException {
        int totalBytesRead;
        int bytesRead;
        Preconditions.checkNotNull((Object)stream, (Object)"stream");
        Preconditions.checkNotNull((Object)stream, (Object)"target");
        Preconditions.checkElementIndex((int)startOffset, (int)target.length, (String)"startOffset");
        Exceptions.checkArgument(maxLength >= 0, "maxLength", "maxLength must be a non-negative number.", new Object[0]);
        for (totalBytesRead = 0; totalBytesRead < maxLength && (bytesRead = stream.read(target, startOffset + totalBytesRead, maxLength - totalBytesRead)) >= 0; totalBytesRead += bytesRead) {
        }
        return totalBytesRead;
    }

    public static byte[] readAll(InputStream source, int length) throws IOException {
        byte[] ret = new byte[length];
        int readBytes = StreamHelpers.readAll(source, ret, 0, ret.length);
        if (readBytes < ret.length) {
            throw new EOFException(String.format("Was only able to read %d bytes, which is less than the requested length of %d.", readBytes, ret.length));
        }
        return ret;
    }
}

