/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.io.filesystem;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.io.filesystem.FileModificationMonitor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileModificationEventWatcher
extends Thread
implements FileModificationMonitor {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(FileModificationEventWatcher.class);
    private static final AtomicInteger THREAD_NUM = new AtomicInteger();
    private final Path watchedFilePath;
    private final Consumer<WatchEvent<?>> callback;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionalHandler = (t, e) -> this.logException(e);
    private final boolean loopContinuously;
    private boolean isWatchRegistered = false;

    public FileModificationEventWatcher(@NonNull Path fileToWatch, @NonNull Consumer<WatchEvent<?>> callback) throws FileNotFoundException {
        this(fileToWatch, callback, true, true);
        if (fileToWatch == null) {
            throw new NullPointerException("fileToWatch is marked @NonNull but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked @NonNull but is null");
        }
    }

    @VisibleForTesting
    FileModificationEventWatcher(@NonNull Path fileToWatch, @NonNull Consumer<WatchEvent<?>> callback, boolean loopContinuously, boolean checkForFileExistence) throws FileNotFoundException {
        super("pravega-file-watcher-" + THREAD_NUM.incrementAndGet());
        if (fileToWatch == null) {
            throw new NullPointerException("fileToWatch is marked @NonNull but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked @NonNull but is null");
        }
        Exceptions.checkNotNullOrEmpty(fileToWatch.toString(), "fileToWatch");
        if (checkForFileExistence && !fileToWatch.toFile().exists()) {
            throw new FileNotFoundException(String.format("File [%s] does not exist.", fileToWatch));
        }
        this.watchedFilePath = fileToWatch;
        this.callback = callback;
        this.loopContinuously = loopContinuously;
        this.setUncaughtExceptionHandler(this.uncaughtExceptionalHandler);
    }

    @VisibleForTesting
    String getWatchedFileName() {
        Path fileName = this.watchedFilePath.getFileName();
        if (fileName != null) {
            return fileName.toString();
        }
        throw new IllegalStateException("File name is null");
    }

    @VisibleForTesting
    Path getWatchedDirectory() {
        return this.watchedFilePath.getParent();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        watchKey = null;
        watchService = null;
        try {
            watchService = FileSystems.getDefault().newWatchService();
            FileModificationEventWatcher.log.debug("Done creating watch service for watching file at path: {}", (Object)this.watchedFilePath);
            fileName = this.getWatchedFileName();
            directoryPath = this.getWatchedDirectory();
            FileModificationEventWatcher.log.debug("Directory being watched is {}", (Object)directoryPath);
            if (!FileModificationEventWatcher.$assertionsDisabled && directoryPath == null) {
                throw new AssertionError();
            }
            directoryPath.register(watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE});
            FileModificationEventWatcher.log.debug("Registered the watch for the file: {}", (Object)this.watchedFilePath);
            this.isWatchRegistered = true;
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    watchKey = this.retrieveWatchKeyFrom(watchService);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.logException(e);
                }
                if (watchKey == null) ** GOTO lbl-1000
                modificationDetectionEvent = watchKey.pollEvents().stream().filter((Predicate<WatchEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$run$1(java.lang.String java.nio.file.WatchEvent ), (Ljava/nio/file/WatchEvent;)Z)((String)fileName)).findAny();
                if (modificationDetectionEvent.isPresent()) {
                    FileModificationEventWatcher.log.info("Detected that the file [{}] has modified", (Object)this.watchedFilePath);
                    this.callback.accept(modificationDetectionEvent.get());
                }
                isKeyValid = watchKey.reset();
                FileModificationEventWatcher.log.debug("Done resetting watch key.");
                if (!isKeyValid) {
                    FileModificationEventWatcher.log.info("No longer watching file [{}]", (Object)this.watchedFilePath);
                } else if (this.loopContinuously) continue;
                break;
            }
        }
        catch (IOException e) {
            this.logException(e);
            throw new RuntimeException(e);
        }
        finally {
            if (watchKey != null) {
                watchKey.cancel();
            }
            if (watchService != null) {
                try {
                    watchService.close();
                }
                catch (IOException e) {
                    FileModificationEventWatcher.log.warn("Error closing watch service", (Throwable)e);
                }
            }
        }
        FileModificationEventWatcher.log.info("Thread [{}], watching for modifications in file [{}] exiting,", (Object)this.getName(), (Object)this.watchedFilePath);
    }

    private WatchKey retrieveWatchKeyFrom(WatchService watchService) throws InterruptedException {
        WatchKey result = watchService.take();
        log.info("Retrieved and removed watch key for watching file at path: {}", (Object)this.watchedFilePath);
        Thread.sleep(200L);
        return result;
    }

    @Override
    public void startMonitoring() {
        this.setDaemon(true);
        this.start();
        log.info("Completed setting up monitor for watching modifications to file: {}", (Object)this.watchedFilePath);
    }

    @VisibleForTesting
    boolean isWatchRegistered() {
        return this.isWatchRegistered;
    }

    @Override
    public void stopMonitoring() {
        this.interrupt();
        log.info("Stopped the monitor that was watching modifications to file {}", (Object)this.watchedFilePath);
    }

    private void logException(Throwable e) {
        log.warn("Thread [{}], watching for modifications in file [{}], encountered exception with cause [{}]", new Object[]{this.getName(), this.watchedFilePath, e.getMessage()});
    }

    private static /* synthetic */ boolean lambda$run$1(String fileName, WatchEvent event) {
        return event.context().toString().contains(fileName);
    }
}

