/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.io.serialization;

import io.pravega.common.util.BufferView;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.ToIntFunction;

public interface RevisionDataOutput
extends DataOutput {
    public static final long COMPACT_LONG_MAX = 0x3FFFFFFFFFFFFFFEL;
    public static final long COMPACT_LONG_MIN = 0L;
    public static final long COMPACT_SIGNED_LONG_MAX = 0x1FFFFFFFFFFFFFFEL;
    public static final long COMPACT_SIGNED_LONG_MIN = -2305843009213693951L;
    public static final int COMPACT_INT_MAX = 0x3FFFFFFE;
    public static final int COMPACT_INT_MIN = 0;
    public static final int UUID_BYTES = 16;

    public boolean requiresExplicitLength();

    public void length(int var1) throws IOException;

    public OutputStream getBaseStream();

    public int getUTFLength(String var1);

    public int getCompactLongLength(long var1);

    public void writeCompactLong(long var1) throws IOException;

    public int getCompactSignedLongLength(long var1);

    public void writeCompactSignedLong(long var1) throws IOException;

    public int getCompactIntLength(int var1);

    public void writeCompactInt(int var1) throws IOException;

    public void writeUUID(UUID var1) throws IOException;

    public int getCollectionLength(int var1, int var2);

    public <T> int getCollectionLength(Collection<T> var1, ToIntFunction<T> var2);

    public <T> int getCollectionLength(T[] var1, ToIntFunction<T> var2);

    public <T> void writeCollection(Collection<T> var1, ElementSerializer<T> var2) throws IOException;

    public <T> void writeArray(T[] var1, ElementSerializer<T> var2) throws IOException;

    default public void writeArray(byte[] array) throws IOException {
        this.writeArray(array, 0, array == null ? 0 : array.length);
    }

    public void writeArray(byte[] var1, int var2, int var3) throws IOException;

    public void writeBuffer(BufferView var1) throws IOException;

    public int getMapLength(int var1, int var2, int var3);

    public <K, V> int getMapLength(Map<K, V> var1, ToIntFunction<K> var2, ToIntFunction<V> var3);

    public <K, V> void writeMap(Map<K, V> var1, ElementSerializer<K> var2, ElementSerializer<V> var3) throws IOException;

    @FunctionalInterface
    public static interface ElementSerializer<T> {
        public void accept(RevisionDataOutput var1, T var2) throws IOException;
    }
}

