/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.io.serialization;

import io.pravega.common.io.SerializationException;
import io.pravega.common.io.serialization.RandomAccessOutputStream;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.util.BitConverter;
import io.pravega.common.util.BufferView;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.ToIntFunction;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
abstract class RevisionDataOutputStream
extends DataOutputStream
implements RevisionDataOutput {
    private RevisionDataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public static RevisionDataOutputStream wrap(OutputStream outputStream) throws IOException {
        if (outputStream instanceof RandomAccessOutputStream) {
            return new RandomRevisionDataOutput(outputStream);
        }
        return new NonSeekableRevisionDataOutput(outputStream);
    }

    @Override
    public int getUTFLength(String s) {
        int charCount = s.length();
        int length = 2;
        for (int i = 0; i < charCount; ++i) {
            char c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++length;
                continue;
            }
            if (c > '\u07ff') {
                length += 3;
                continue;
            }
            length += 2;
        }
        return length;
    }

    @Override
    public int getCompactLongLength(long value) {
        if (value < 0L || value > 0x3FFFFFFFFFFFFFFEL) {
            throw new IllegalArgumentException(this.badArgRange("writeCompactLong", "longs", "[0, 2^62)", value));
        }
        if (value > 0x3FFFFFFFL) {
            return 8;
        }
        if (value > 16383L) {
            return 4;
        }
        if (value > 63L) {
            return 2;
        }
        return 1;
    }

    @Override
    public void writeCompactLong(long value) throws IOException {
        if (value < 0L || value > 0x3FFFFFFFFFFFFFFEL) {
            throw new IllegalArgumentException(this.badArgRange("writeCompactLong", "longs", "[0, 2^62)", value));
        }
        if (value > 0x3FFFFFFFL) {
            this.writeInt((int)(value >>> 32 | 0xFFFFFFFFC0000000L));
            this.writeInt((int)value);
        } else if (value > 16383L) {
            this.writeInt((int)(value | Integer.MIN_VALUE));
        } else if (value > 63L) {
            this.writeShort((short)(value | 0x4000L));
        } else {
            this.writeByte((byte)value);
        }
    }

    @Override
    public int getCompactSignedLongLength(long value) {
        if (value < -2305843009213693951L || value > 0x1FFFFFFFFFFFFFFEL) {
            throw new IllegalArgumentException(this.badArgRange("writeCompactSignedLong", "longs", "[-2^61, 2^61)", value));
        }
        if (value < 0L) {
            value = RevisionDataOutputStream.negateSignedNumber(value);
        }
        if (value > 0x1FFFFFFFL) {
            return 8;
        }
        if (value > 8191L) {
            return 4;
        }
        if (value > 31L) {
            return 2;
        }
        return 1;
    }

    @Override
    public void writeCompactSignedLong(long value) throws IOException {
        boolean negative;
        if (value < -2305843009213693951L || value > 0x1FFFFFFFFFFFFFFEL) {
            throw new IllegalArgumentException(this.badArgRange("writeCompactSignedLong", "longs", "[-2^61, 2^61)", value));
        }
        boolean bl = negative = value < 0L;
        if (negative) {
            value = RevisionDataOutputStream.negateSignedNumber(value);
        }
        if (value > 0x1FFFFFFFL) {
            this.writeInt((int)(value >>> 32 | (long)(negative ? -536870912 : 0x60000000)));
            this.writeInt((int)value);
        } else if (value > 8191L) {
            this.writeInt((int)(value | (long)(negative ? -1073741824 : 0x40000000)));
        } else if (value > 31L) {
            this.writeShort((short)(value | (long)(negative ? 40960 : 8192)));
        } else if (negative) {
            this.writeByte((byte)value | 0x80);
        } else {
            this.writeByte((byte)value);
        }
    }

    @Override
    public int getCompactIntLength(int value) {
        if (value < 0 || value > 0x3FFFFFFE) {
            throw new IllegalArgumentException(this.badArgRange("writeCompactInt", "ints", "[0, 2^30)", value));
        }
        if (value > 16383) {
            return 4;
        }
        if (value > 127) {
            return 2;
        }
        return 1;
    }

    @Override
    public void writeCompactInt(int value) throws IOException {
        if (value < 0 || value > 0x3FFFFFFE) {
            throw new IllegalArgumentException(this.badArgRange("writeCompactInt", "ints", "[0, 2^30)", value));
        }
        if (value > 16383) {
            this.writeInt(value | 0xC0000000);
        } else if (value > 127) {
            this.writeShort((short)(value | 0x8000));
        } else {
            this.writeByte((byte)value);
        }
    }

    @Override
    public void writeUUID(UUID uuid) throws IOException {
        this.writeLong(uuid.getMostSignificantBits());
        this.writeLong(uuid.getLeastSignificantBits());
    }

    @Override
    public int getCollectionLength(int elementCount, int elementLength) {
        return this.getCompactIntLength(elementCount) + elementCount * elementLength;
    }

    @Override
    public <T> int getCollectionLength(Collection<T> collection, ToIntFunction<T> elementLengthProvider) {
        if (collection == null) {
            return this.getCompactIntLength(0);
        }
        return this.getCompactIntLength(collection.size()) + collection.stream().mapToInt(elementLengthProvider).sum();
    }

    @Override
    public <T> int getCollectionLength(T[] array, ToIntFunction<T> elementLengthProvider) {
        if (array == null) {
            return this.getCompactIntLength(0);
        }
        return this.getCompactIntLength(array.length) + Arrays.stream(array).mapToInt(elementLengthProvider).sum();
    }

    @Override
    public <T> void writeCollection(Collection<T> collection, RevisionDataOutput.ElementSerializer<T> elementSerializer) throws IOException {
        if (collection == null) {
            this.writeCompactInt(0);
            return;
        }
        this.writeCompactInt(collection.size());
        for (T e : collection) {
            elementSerializer.accept(this, e);
        }
    }

    @Override
    public <T> void writeArray(T[] array, RevisionDataOutput.ElementSerializer<T> elementSerializer) throws IOException {
        if (array == null) {
            this.writeCompactInt(0);
            return;
        }
        this.writeCompactInt(array.length);
        for (T e : array) {
            elementSerializer.accept(this, e);
        }
    }

    @Override
    public void writeArray(byte[] array, int offset, int length) throws IOException {
        if (array == null) {
            this.writeCompactInt(0);
            return;
        }
        if (offset < 0 || offset > array.length || length < 0 || offset + length > array.length) {
            throw new ArrayIndexOutOfBoundsException("offset and length must refer to a range within the given array.");
        }
        this.writeCompactInt(length);
        this.write(array, offset, length);
    }

    @Override
    public void writeBuffer(BufferView buf) throws IOException {
        if (buf == null) {
            this.writeCompactInt(0);
            return;
        }
        this.writeCompactInt(buf.getLength());
        buf.copyTo(this);
    }

    @Override
    public int getMapLength(int elementCount, int keyLength, int valueLength) {
        return this.getCompactIntLength(elementCount) + elementCount * (keyLength + valueLength);
    }

    @Override
    public <K, V> int getMapLength(Map<K, V> map, ToIntFunction<K> keyLengthProvider, ToIntFunction<V> valueLengthProvider) {
        if (map == null) {
            return this.getCompactIntLength(0);
        }
        return this.getCompactIntLength(map.size()) + map.entrySet().stream().mapToInt(e -> keyLengthProvider.applyAsInt(e.getKey()) + valueLengthProvider.applyAsInt(e.getValue())).sum();
    }

    @Override
    public <K, V> void writeMap(Map<K, V> map, RevisionDataOutput.ElementSerializer<K> keySerializer, RevisionDataOutput.ElementSerializer<V> valueSerializer) throws IOException {
        if (map == null) {
            this.writeCompactInt(0);
            return;
        }
        this.writeCompactInt(map.size());
        for (Map.Entry<K, V> e : map.entrySet()) {
            keySerializer.accept(this, e.getKey());
            valueSerializer.accept(this, e.getValue());
        }
    }

    private <T> String badArgRange(String methodName, String type, String interval, T arg) {
        return String.format("%s can only serialize %s in the interval %s, given %s.", methodName, type, interval, arg);
    }

    static long negateSignedNumber(long value) {
        return -value - 1L;
    }

    @NotThreadSafe
    private static class NonSeekableRevisionDataOutput
    extends RevisionDataOutputStream {
        private final OutputStream realStream;
        private int length;

        NonSeekableRevisionDataOutput(OutputStream outputStream) {
            super(new LengthRequiredOutputStream());
            this.realStream = outputStream;
            this.length = 0;
        }

        @Override
        public void close() throws IOException {
            if (this.length != this.size()) {
                throw new SerializationException(String.format("Unexpected number of bytes written. Declared: %d, written: %d.", this.length, this.size()));
            }
            if (this.requiresExplicitLength()) {
                this.length(0);
            }
        }

        @Override
        public OutputStream getBaseStream() {
            return this;
        }

        @Override
        public boolean requiresExplicitLength() {
            return this.out instanceof LengthRequiredOutputStream;
        }

        @Override
        public void length(int length) throws IOException {
            if (this.requiresExplicitLength()) {
                BitConverter.writeInt(this.realStream, length);
                this.out = this.realStream;
                this.length = length;
            }
        }

        private static class LengthRequiredOutputStream
        extends OutputStream {
            private LengthRequiredOutputStream() {
            }

            @Override
            public void write(int i) {
                throw new IllegalStateException("Length must be declared prior to writing anything.");
            }

            @Override
            public void write(byte[] buffer, int index, int length) {
                throw new IllegalStateException("Length must be declared prior to writing anything.");
            }
        }
    }

    private static class RandomRevisionDataOutput
    extends RevisionDataOutputStream {
        private final int initialPosition;

        RandomRevisionDataOutput(OutputStream outputStream) throws IOException {
            super(outputStream);
            this.initialPosition = ((RandomAccessOutputStream)((Object)outputStream)).size();
            BitConverter.writeInt(outputStream, 0);
        }

        @Override
        public void close() throws IOException {
            RandomAccessOutputStream ros = (RandomAccessOutputStream)((Object)this.out);
            int length = ros.size() - this.initialPosition - 4;
            BitConverter.writeInt(ros.subStream(this.initialPosition, 4), length);
        }

        @Override
        public OutputStream getBaseStream() {
            return this.out;
        }

        @Override
        public boolean requiresExplicitLength() {
            return false;
        }

        @Override
        public void length(int length) throws IOException {
        }
    }
}

