/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.io.serialization;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.EnhancedByteArrayOutputStream;
import io.pravega.common.io.SerializationException;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataInputStream;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.RevisionDataOutputStream;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.ByteArraySegment;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;

public abstract class VersionedSerializer<T> {
    private static final int SERIALIZER_VERSION = 0;

    public void serialize(RevisionDataOutput dataOutput, T object) throws IOException {
        this.serialize(dataOutput.getBaseStream(), object);
    }

    public ByteArraySegment serialize(T object) throws IOException {
        EnhancedByteArrayOutputStream result = new EnhancedByteArrayOutputStream();
        this.serialize(result, object);
        return result.getData();
    }

    public abstract void serialize(OutputStream var1, T var2) throws IOException;

    void processHeader(InputStream dataInput) throws IOException {
        int formatVersion = dataInput.read();
        if (formatVersion < 0) {
            throw new EOFException();
        }
        this.ensureCondition(formatVersion == 0, "Unsupported format version %d.", formatVersion);
    }

    void ensureCondition(boolean condition, String messageFormat, Object ... args) throws SerializationException {
        if (!condition) {
            throw new SerializationException(String.format(messageFormat, args));
        }
    }

    public static abstract class MultiType<BaseType>
    extends VersionedSerializer<BaseType> {
        private final Map<Byte, SerializerInfo> serializersById;
        private final Map<Class<?>, SerializerInfo> serializersByType;

        public MultiType() {
            Builder builder = new Builder();
            this.declareSerializers(builder);
            this.serializersByType = builder.builderByType.build();
            this.serializersById = builder.builderById.build();
        }

        protected abstract void declareSerializers(Builder var1);

        @Override
        public void serialize(OutputStream stream, BaseType o) throws IOException {
            Class<?> c = o.getClass();
            SerializerInfo si = this.serializersByType.get(c);
            this.ensureCondition(si != null, "No serializer found for %s.", c.getName());
            si.serializer.beforeSerialization(o);
            stream.write(0);
            stream.write(si.id);
            si.serializer.serializeContents(stream, o);
        }

        public BaseType deserialize(InputStream stream) throws IOException {
            this.processHeader(stream);
            byte type = (byte)stream.read();
            if (type < 0) {
                throw new EOFException();
            }
            SerializerInfo si = this.serializersById.get(type);
            this.ensureCondition(si != null, "No serializer found for object type %s.", type);
            return (BaseType)si.serializer.deserializeContents(stream);
        }

        public BaseType deserialize(ArrayView data) throws IOException {
            return this.deserialize(data.getReader());
        }

        protected final class Builder {
            private final ImmutableMap.Builder<Byte, SerializerInfo> builderById = ImmutableMap.builder();
            private final ImmutableMap.Builder<Class<?>, SerializerInfo> builderByType = ImmutableMap.builder();

            protected Builder() {
            }

            public <TargetType extends BaseType, ReaderType extends ObjectBuilder<TargetType>> Builder serializer(Class<TargetType> type, int serializationTypeId, WithBuilder<TargetType, ReaderType> serializer) {
                Preconditions.checkArgument((serializationTypeId >= 0 && serializationTypeId <= 127 ? 1 : 0) != 0, (String)"SerializationTypeId must be a value between 0 and ", (int)127);
                SerializerInfo si = new SerializerInfo(type, (byte)serializationTypeId, serializer);
                this.builderById.put((Object)si.id, (Object)si);
                this.builderByType.put(si.type, (Object)si);
                return this;
            }
        }

        private static class SerializerInfo {
            final Class<?> type;
            final byte id;
            final WithBuilder serializer;

            @ConstructorProperties(value={"type", "id", "serializer"})
            @SuppressFBWarnings(justification="generated code")
            public SerializerInfo(Class<?> type, byte id, WithBuilder serializer) {
                this.type = type;
                this.id = id;
                this.serializer = serializer;
            }
        }
    }

    public static abstract class WithBuilder<TargetType, ReaderType extends ObjectBuilder<TargetType>>
    extends SingleType<TargetType, ReaderType> {
        protected abstract ReaderType newBuilder();

        public TargetType deserialize(RevisionDataInput dataInput) throws IOException {
            return this.deserialize(dataInput.getBaseStream());
        }

        public TargetType deserialize(InputStream stream) throws IOException {
            ReaderType builder = this.newBuilder();
            this.deserialize(stream, builder);
            return (TargetType)builder.build();
        }

        public TargetType deserialize(byte[] data) throws IOException {
            return this.deserialize(new ByteArrayInputStream(data));
        }

        public TargetType deserialize(ArrayView data) throws IOException {
            return this.deserialize(data.getReader());
        }

        TargetType deserializeContents(InputStream stream) throws IOException {
            ReaderType builder = this.newBuilder();
            super.deserializeContents(stream, builder);
            return (TargetType)builder.build();
        }
    }

    public static abstract class Direct<TargetType>
    extends SingleType<TargetType, TargetType> {
    }

    private static abstract class SingleType<TargetType, ReaderType>
    extends VersionedSerializer<TargetType> {
        private final FormatVersion<TargetType, ReaderType>[] versions = new FormatVersion[127];

        SingleType() {
            this.declareVersions();
            Preconditions.checkArgument((this.versions[this.getWriteVersion()] != null ? 1 : 0) != 0, (String)"Write version %s is not defined.", (int)this.getWriteVersion());
        }

        protected abstract byte getWriteVersion();

        protected abstract void declareVersions();

        protected FormatVersion<TargetType, ReaderType> version(int version) {
            FormatVersion<TargetType, ReaderType> v = this.versions[version];
            if (v == null) {
                v = new FormatVersion(version);
                this.versions[v.getVersion()] = v;
            }
            return v;
        }

        @Override
        public void serialize(OutputStream stream, TargetType object) throws IOException {
            this.beforeSerialization(object);
            stream.write(0);
            this.serializeContents(stream, object);
        }

        protected void beforeSerialization(TargetType object) {
        }

        void serializeContents(OutputStream stream, TargetType o) throws IOException {
            DataOutputStream dataOutput = stream instanceof DataOutputStream ? (DataOutputStream)stream : new DataOutputStream(stream);
            FormatVersion<TargetType, ReaderType> writeVersion = this.versions[this.getWriteVersion()];
            dataOutput.writeByte(writeVersion.getVersion());
            dataOutput.writeByte(writeVersion.getRevisions().size());
            for (FormatRevision<TargetType, ReaderType> r : writeVersion.getRevisions()) {
                dataOutput.writeByte(r.getRevision());
                RevisionDataOutputStream revisionOutput = RevisionDataOutputStream.wrap(stream);
                Throwable throwable = null;
                try {
                    r.getWriter().accept(o, revisionOutput);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (revisionOutput == null) continue;
                    if (throwable != null) {
                        try {
                            revisionOutput.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    revisionOutput.close();
                }
            }
        }

        public void deserialize(RevisionDataInput dataInput, ReaderType target) throws IOException {
            this.deserialize(dataInput.getBaseStream(), target);
        }

        public void deserialize(ArrayView data, ReaderType target) throws IOException {
            this.deserialize(data.getReader(), target);
        }

        public void deserialize(InputStream stream, ReaderType target) throws IOException {
            this.processHeader(stream);
            this.deserializeContents(stream, target);
        }

        void deserializeContents(InputStream stream, ReaderType target) throws IOException {
            DataInputStream dataInput = stream instanceof DataInputStream ? (DataInputStream)stream : new DataInputStream(stream);
            byte version = dataInput.readByte();
            FormatVersion<TargetType, ReaderType> readVersion = this.versions[version];
            this.ensureCondition(readVersion != null, "Unsupported version %d.", version);
            int revisionCount = dataInput.readByte();
            this.ensureCondition(revisionCount >= 0, "Data corruption: negative revision count.", new Object[0]);
            int revisionIndex = 0;
            for (int i = 0; i < revisionCount; ++i) {
                byte revision = dataInput.readByte();
                FormatRevision rd = ((FormatVersion)readVersion).get(revisionIndex++);
                try (RevisionDataInputStream revisionInput = RevisionDataInputStream.wrap(stream);){
                    if (rd == null) continue;
                    this.ensureCondition(revision == rd.getRevision(), "Unexpected revision. Expected %d, found %d.", rd.getRevision(), revision);
                    rd.getReader().accept(revisionInput, target);
                    continue;
                }
            }
        }
    }

    @FunctionalInterface
    protected static interface StreamReader<ReaderType> {
        public void accept(RevisionDataInput var1, ReaderType var2) throws IOException;
    }

    @FunctionalInterface
    protected static interface StreamWriter<TargetType> {
        public void accept(TargetType var1, RevisionDataOutput var2) throws IOException;
    }

    private static class FormatRevision<TargetType, ReaderType> {
        private final byte revision;
        private final StreamWriter<TargetType> writer;
        private final StreamReader<ReaderType> reader;

        @ConstructorProperties(value={"revision", "writer", "reader"})
        @SuppressFBWarnings(justification="generated code")
        public FormatRevision(byte revision, StreamWriter<TargetType> writer, StreamReader<ReaderType> reader) {
            this.revision = revision;
            this.writer = writer;
            this.reader = reader;
        }

        @SuppressFBWarnings(justification="generated code")
        public byte getRevision() {
            return this.revision;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamWriter<TargetType> getWriter() {
            return this.writer;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamReader<ReaderType> getReader() {
            return this.reader;
        }
    }

    protected static class FormatVersion<TargetType, ReaderType> {
        private final byte version;
        private final ArrayList<FormatRevision<TargetType, ReaderType>> revisions = new ArrayList();

        private FormatVersion(int version) {
            Preconditions.checkArgument((version >= 0 && version <= 127 ? 1 : 0) != 0, (String)"Version must be a value between 0 and ", (int)127);
            this.version = (byte)version;
        }

        public FormatVersion<TargetType, ReaderType> revision(int revision, StreamWriter<TargetType> writer, StreamReader<ReaderType> reader) {
            Preconditions.checkNotNull(writer, (Object)"writer");
            Preconditions.checkNotNull(reader, (Object)"reader");
            Preconditions.checkArgument((revision >= 0 && revision <= 127 ? 1 : 0) != 0, (String)"Revision must be a non-negative value and less than or equal to %s.", (int)127);
            Preconditions.checkArgument((this.revisions.isEmpty() || revision == this.revisions.get(this.revisions.size() - 1).getRevision() + 1 ? 1 : 0) != 0, (Object)"Expected revision to be incremental.");
            this.revisions.add(new FormatRevision<TargetType, ReaderType>((byte)revision, writer, reader));
            return this;
        }

        private FormatRevision<TargetType, ReaderType> get(int revisionId) {
            return revisionId < this.revisions.size() ? this.revisions.get(revisionId) : null;
        }

        @SuppressFBWarnings(justification="generated code")
        public byte getVersion() {
            return this.version;
        }

        @SuppressFBWarnings(justification="generated code")
        public ArrayList<FormatRevision<TargetType, ReaderType>> getRevisions() {
            return this.revisions;
        }
    }
}

