/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import io.pravega.common.concurrent.Futures;
import io.pravega.common.concurrent.SequentialProcessor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;

public interface AsyncIterator<T> {
    public CompletableFuture<T> getNext();

    default public CompletableFuture<Void> forEachRemaining(Consumer<? super T> consumer, Executor executor) {
        AtomicBoolean canContinue = new AtomicBoolean(true);
        return Futures.loop(canContinue::get, this::getNext, e -> {
            if (e == null) {
                canContinue.set(false);
            } else {
                consumer.accept(e);
            }
        }, executor);
    }

    default public AsyncIterator<T> asSequential(Executor executor) {
        SequentialProcessor processor = new SequentialProcessor(executor);
        return () -> {
            CompletableFuture result = processor.add(this::getNext);
            result.thenAccept(r -> {
                if (r == null) {
                    processor.close();
                }
            });
            return result;
        };
    }

    default public CompletableFuture<Void> collectRemaining(Predicate<? super T> collector) {
        return this.getNext().thenCompose(e -> {
            boolean canContinue;
            boolean bl = canContinue = e != null && collector.test(e);
            if (canContinue) {
                return this.collectRemaining(collector);
            }
            return CompletableFuture.completedFuture(null);
        });
    }
}

