/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import io.pravega.common.util.ArrayView;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public final class BitConverter {
    public static int writeShort(ArrayView target, int offset, short value) {
        return BitConverter.writeShort(target.array(), target.arrayOffset() + offset, value);
    }

    public static int writeShort(byte[] target, int offset, short value) {
        target[offset] = (byte)(value >>> 8 & 0xFF);
        target[offset + 1] = (byte)(value & 0xFF);
        return 2;
    }

    public static int writeInt(ArrayView target, int offset, int value) {
        return BitConverter.writeInt(target.array(), target.arrayOffset() + offset, value);
    }

    public static int writeInt(byte[] target, int offset, int value) {
        target[offset] = (byte)(value >>> 24);
        target[offset + 1] = (byte)(value >>> 16);
        target[offset + 2] = (byte)(value >>> 8);
        target[offset + 3] = (byte)value;
        return 4;
    }

    public static int writeInt(OutputStream target, int value) throws IOException {
        target.write(value >>> 24);
        target.write(value >>> 16);
        target.write(value >>> 8);
        target.write(value);
        return 4;
    }

    public static short readShort(byte[] source, int position) {
        return (short)((source[position] & 0xFF) << 8 | source[position + 1] & 0xFF);
    }

    public static short readShort(ArrayView source, int position) {
        return (short)((source.get(position) & 0xFF) << 8 | source.get(position + 1) & 0xFF);
    }

    public static int readInt(byte[] source, int position) {
        return (source[position] & 0xFF) << 24 | (source[position + 1] & 0xFF) << 16 | (source[position + 2] & 0xFF) << 8 | source[position + 3] & 0xFF;
    }

    public static int readInt(ArrayView source, int position) {
        return (source.get(position) & 0xFF) << 24 | (source.get(position + 1) & 0xFF) << 16 | (source.get(position + 2) & 0xFF) << 8 | source.get(position + 3) & 0xFF;
    }

    public static int readInt(InputStream source) throws IOException {
        int b4;
        int b3;
        int b2;
        int b1 = source.read();
        if ((b1 | (b2 = source.read()) | (b3 = source.read()) | (b4 = source.read())) < 0) {
            throw new EOFException();
        }
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    public static int writeLong(ArrayView target, int offset, long value) {
        return BitConverter.writeLong(target.array(), target.arrayOffset() + offset, value);
    }

    public static int writeLong(byte[] target, int offset, long value) {
        target[offset] = (byte)(value >>> 56);
        target[offset + 1] = (byte)(value >>> 48);
        target[offset + 2] = (byte)(value >>> 40);
        target[offset + 3] = (byte)(value >>> 32);
        target[offset + 4] = (byte)(value >>> 24);
        target[offset + 5] = (byte)(value >>> 16);
        target[offset + 6] = (byte)(value >>> 8);
        target[offset + 7] = (byte)value;
        return 8;
    }

    public static int writeUUID(byte[] target, int offset, UUID value) {
        BitConverter.writeLong(target, offset, value.getMostSignificantBits());
        BitConverter.writeLong(target, offset + 8, value.getLeastSignificantBits());
        return 16;
    }

    public static UUID readUUID(ArrayView source, int position) {
        long msb = BitConverter.readLong(source, position);
        long lsb = BitConverter.readLong(source, position + 8);
        return new UUID(msb, lsb);
    }

    public static UUID readUUID(byte[] source, int position) {
        long msb = BitConverter.readLong(source, position);
        long lsb = BitConverter.readLong(source, position + 8);
        return new UUID(msb, lsb);
    }

    public static long readLong(ArrayView source, int position) {
        return (long)(source.get(position) & 0xFF) << 56 | (long)(source.get(position + 1) & 0xFF) << 48 | (long)(source.get(position + 2) & 0xFF) << 40 | (long)(source.get(position + 3) & 0xFF) << 32 | (long)(source.get(position + 4) & 0xFF) << 24 | (long)((source.get(position + 5) & 0xFF) << 16) | (long)((source.get(position + 6) & 0xFF) << 8) | (long)(source.get(position + 7) & 0xFF);
    }

    public static long readLong(byte[] source, int position) {
        return (long)(source[position] & 0xFF) << 56 | (long)(source[position + 1] & 0xFF) << 48 | (long)(source[position + 2] & 0xFF) << 40 | (long)(source[position + 3] & 0xFF) << 32 | (long)(source[position + 4] & 0xFF) << 24 | (long)((source[position + 5] & 0xFF) << 16) | (long)((source[position + 6] & 0xFF) << 8) | (long)(source[position + 7] & 0xFF);
    }

    public static long readLong(InputStream source) throws IOException {
        int b8;
        int b7;
        int b6;
        int b5;
        int b4;
        int b3;
        int b2;
        int b1 = source.read();
        if ((b1 | (b2 = source.read()) | (b3 = source.read()) | (b4 = source.read()) | (b5 = source.read()) | (b6 = source.read()) | (b7 = source.read()) | (b8 = source.read())) < 0) {
            throw new EOFException();
        }
        return ((long)b1 << 56) + ((long)(b2 & 0xFF) << 48) + ((long)(b3 & 0xFF) << 40) + ((long)(b4 & 0xFF) << 32) + ((long)(b5 & 0xFF) << 24) + (long)((b6 & 0xFF) << 16) + (long)((b7 & 0xFF) << 8) + (long)(b8 & 0xFF);
    }

    public static int writeUnsignedLong(byte[] target, int offset, long value) {
        return BitConverter.writeLong(target, offset, value ^ Long.MIN_VALUE);
    }

    public static long readUnsignedLong(ArrayView source, int position) {
        return BitConverter.readLong(source, position) ^ Long.MIN_VALUE;
    }
}

