/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import com.google.common.base.Preconditions;
import io.pravega.common.Exceptions;
import io.pravega.common.io.FixedByteArrayOutputStream;
import io.pravega.common.util.ArrayView;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ByteArraySegment
implements ArrayView {
    private final byte[] array;
    private final int startOffset;
    private final int length;
    private final boolean readOnly;

    public ByteArraySegment(byte[] array) {
        this(array, 0, array.length);
    }

    public ByteArraySegment(byte[] array, int startOffset, int length) {
        this(array, startOffset, length, false);
    }

    public ByteArraySegment(ByteBuffer buff) {
        this(buff.array(), buff.arrayOffset() + buff.position(), buff.remaining(), false);
    }

    public ByteArraySegment(byte[] array, int startOffset, int length, boolean readOnly) {
        Preconditions.checkNotNull((Object)array, (Object)"array");
        Exceptions.checkArrayRange(startOffset, length, array.length, "startOffset", "length");
        this.array = array;
        this.startOffset = startOffset;
        this.length = length;
        this.readOnly = readOnly;
    }

    @Override
    public byte get(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.length, (String)"index");
        return this.array[index + this.startOffset];
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public byte[] array() {
        return this.array;
    }

    @Override
    public int arrayOffset() {
        return this.startOffset;
    }

    @Override
    public InputStream getReader() {
        return new ByteArrayInputStream(this.array, this.startOffset, this.length);
    }

    @Override
    public InputStream getReader(int offset, int length) {
        Exceptions.checkArrayRange(offset, length, this.length, "offset", "length");
        return new ByteArrayInputStream(this.array, this.startOffset + offset, length);
    }

    @Override
    public byte[] getCopy() {
        byte[] buffer = new byte[this.length];
        System.arraycopy(this.array, this.startOffset, buffer, 0, this.length);
        return buffer;
    }

    @Override
    public void copyTo(byte[] target, int targetOffset, int length) {
        Preconditions.checkElementIndex((int)length, (int)(this.length + 1), (String)"length");
        Exceptions.checkArrayRange(targetOffset, length, target.length, "index", "values.length");
        System.arraycopy(this.array, this.startOffset, target, targetOffset, length);
    }

    @Override
    public void copyTo(OutputStream stream) throws IOException {
        stream.write(this.array, this.startOffset, this.length);
    }

    public void set(int index, byte value) {
        Preconditions.checkState((!this.readOnly ? 1 : 0) != 0, (Object)"Cannot modify a read-only ByteArraySegment.");
        Preconditions.checkElementIndex((int)index, (int)this.length, (String)"index");
        this.array[index + this.startOffset] = value;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void copyFrom(ByteArraySegment source, int targetOffset, int length) {
        Preconditions.checkState((!this.readOnly ? 1 : 0) != 0, (Object)"Cannot modify a read-only ByteArraySegment.");
        Exceptions.checkArrayRange(targetOffset, length, this.length, "index", "values.length");
        Preconditions.checkElementIndex((int)length, (int)(source.getLength() + 1), (String)"length");
        System.arraycopy(source.array, source.startOffset, this.array, targetOffset + this.startOffset, length);
    }

    public void copyFrom(ByteArraySegment source, int sourceOffset, int targetOffset, int length) {
        Preconditions.checkState((!this.readOnly ? 1 : 0) != 0, (Object)"Cannot modify a read-only ByteArraySegment.");
        Exceptions.checkArrayRange(sourceOffset, length, source.length, "index", "values.length");
        Exceptions.checkArrayRange(targetOffset, length, this.length, "index", "values.length");
        Preconditions.checkElementIndex((int)length, (int)(source.getLength() + 1), (String)"length");
        System.arraycopy(source.array, source.startOffset + sourceOffset, this.array, this.startOffset + targetOffset, length);
    }

    public OutputStream getWriter() {
        Preconditions.checkState((!this.readOnly ? 1 : 0) != 0, (Object)"Cannot modify a read-only ByteArraySegment.");
        return new FixedByteArrayOutputStream(this.array, this.startOffset, this.length);
    }

    public ByteArraySegment subSegment(int offset, int length) {
        return this.subSegment(offset, length, this.readOnly);
    }

    public ByteArraySegment subSegment(int offset, int length, boolean readOnly) {
        Exceptions.checkArrayRange(offset, length, this.length, "offset", "length");
        return new ByteArraySegment(this.array, this.startOffset + offset, length, readOnly || this.readOnly);
    }

    public ByteArraySegment asReadOnly() {
        if (this.isReadOnly()) {
            return this;
        }
        return new ByteArraySegment(this.array, this.startOffset, this.length, true);
    }

    public String toString() {
        if (this.getLength() > 128) {
            return String.format("Length = %s", this.getLength());
        }
        return String.format("{%s}", IntStream.range(this.arrayOffset(), this.arrayOffset() + this.getLength()).boxed().map(i -> Byte.toString(this.array[i])).collect(Collectors.joining(",")));
    }
}

