/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;

public class CircularBuffer {
    private final ByteBuffer readBuffer;
    private final ByteBuffer fillBuffer;
    private final int capacity;

    public CircularBuffer(int capacity) {
        this.capacity = capacity;
        byte[] buffer = new byte[capacity];
        this.readBuffer = ByteBuffer.wrap(buffer);
        this.fillBuffer = ByteBuffer.wrap(buffer);
        this.clear();
    }

    public void clear() {
        this.readBuffer.position(0).limit(0);
        this.fillBuffer.position(0).limit(this.fillBuffer.capacity());
    }

    public int read(ByteBuffer toFill) {
        int originalPos = toFill.position();
        while (this.dataAvailable() > 0 && toFill.hasRemaining()) {
            this.readHelper(toFill);
        }
        return toFill.position() - originalPos;
    }

    private void readHelper(ByteBuffer toFill) {
        int readLimit = this.readBuffer.limit();
        int toRead = Math.min(toFill.remaining(), this.readBuffer.remaining());
        this.readBuffer.limit(this.readBuffer.position() + toRead);
        toFill.put(this.readBuffer);
        this.readBuffer.limit(readLimit);
        if (this.readBuffer.position() == this.capacity) {
            this.readBuffer.position(0);
            this.readBuffer.limit(this.fillBuffer.position());
            this.fillBuffer.limit(this.capacity);
        }
        if (this.fillBuffer.position() < this.readBuffer.position()) {
            this.fillBuffer.limit(this.readBuffer.position());
        }
    }

    public int fill(ByteBuffer fillFrom) {
        int origionalPos = fillFrom.position();
        while (this.capacityAvailable() > 0 && fillFrom.hasRemaining()) {
            this.fillHelper(fillFrom);
        }
        return fillFrom.position() - origionalPos;
    }

    private void fillHelper(ByteBuffer fillFrom) {
        int fillLimit = this.fillBuffer.limit();
        int toAdd = Math.min(fillFrom.remaining(), this.fillBuffer.remaining());
        this.fillBuffer.limit(this.fillBuffer.position() + toAdd);
        int limit = fillFrom.limit();
        fillFrom.limit(fillFrom.position() + toAdd);
        this.fillBuffer.put(fillFrom);
        fillFrom.limit(limit);
        this.fillBuffer.limit(fillLimit);
        if (this.fillBuffer.position() == this.capacity) {
            this.fillBuffer.position(0);
            this.fillBuffer.limit(this.readBuffer.position());
            this.readBuffer.limit(this.capacity);
        }
        if (this.readBuffer.position() < this.fillBuffer.position()) {
            this.readBuffer.limit(this.fillBuffer.position());
        }
    }

    public int dataAvailable() {
        if (this.readBuffer.position() < this.fillBuffer.position()) {
            return this.readBuffer.remaining();
        }
        if (this.readBuffer.position() > this.fillBuffer.position()) {
            return this.capacity - this.fillBuffer.remaining();
        }
        if (this.readBuffer.hasRemaining()) {
            return this.readBuffer.remaining() + this.fillBuffer.position();
        }
        return 0;
    }

    public int capacityAvailable() {
        if (this.fillBuffer.position() < this.readBuffer.position()) {
            return this.fillBuffer.remaining();
        }
        if (this.fillBuffer.position() > this.readBuffer.position()) {
            return this.capacity - this.readBuffer.remaining();
        }
        if (this.fillBuffer.hasRemaining()) {
            return this.fillBuffer.remaining() + this.readBuffer.position();
        }
        return 0;
    }

    public String toString() {
        return "Buffer { capacityAvailable:" + this.capacityAvailable() + " dataAvailable: " + this.dataAvailable() + "}";
    }

    @SuppressFBWarnings(justification="generated code")
    public int getCapacity() {
        return this.capacity;
    }
}

