/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class DelimitedStringParser {
    private final String pairDelimiter;
    private final String keyValueDelimiter;
    private final Map<String, Extractor<?>> extractors = new HashMap();

    public static DelimitedStringParser parser(String pairDelimiter, String keyValueDelimiter) {
        Exceptions.checkNotNullOrEmpty(pairDelimiter, "pairDelimiter");
        Exceptions.checkNotNullOrEmpty(keyValueDelimiter, "keyValueDelimiter");
        Preconditions.checkArgument((!pairDelimiter.equals(keyValueDelimiter) ? 1 : 0) != 0, (String)"pairDelimiter (%s) cannot be the same as keyValueDelimiter (%s)", (Object)pairDelimiter, (Object)keyValueDelimiter);
        return new DelimitedStringParser(pairDelimiter, keyValueDelimiter);
    }

    public DelimitedStringParser extractInteger(String key, Consumer<Integer> consumer) {
        this.extractors.put(key, new Extractor<Integer>(consumer, Integer::parseInt));
        return this;
    }

    public DelimitedStringParser extractLong(String key, Consumer<Long> consumer) {
        this.extractors.put(key, new Extractor<Long>(consumer, Long::parseLong));
        return this;
    }

    public DelimitedStringParser extractString(String key, Consumer<String> consumer) {
        this.extractors.put(key, new Extractor<String>(consumer, s -> s));
        return this;
    }

    public DelimitedStringParser extractBoolean(String key, Consumer<Boolean> consumer) {
        this.extractors.put(key, new Extractor<Boolean>(consumer, value -> (value = value.trim().toLowerCase()).equals("true") || value.equals("yes") || value.equals("1")));
        return this;
    }

    public void parse(String s) {
        String[] pairs;
        Preconditions.checkNotNull((Object)s, (Object)"s");
        if (s.length() == 0) {
            return;
        }
        for (String pair : pairs = s.split(this.pairDelimiter)) {
            int delimiterPos = pair.indexOf(this.keyValueDelimiter);
            if (delimiterPos < 0) {
                throw new IllegalArgumentException(String.format("Invalid pair '%s' (missing key-value delimiter).", pair));
            }
            String key = pair.substring(0, delimiterPos);
            String value = delimiterPos == pair.length() - 1 ? "" : pair.substring(delimiterPos + 1);
            Extractor<?> e = this.extractors.get(key);
            Preconditions.checkArgument((e != null ? 1 : 0) != 0, (Object)String.format("No extractor provided for key '%s'.", key));
            ((Extractor)e).process(value);
        }
    }

    @ConstructorProperties(value={"pairDelimiter", "keyValueDelimiter"})
    @SuppressFBWarnings(justification="generated code")
    private DelimitedStringParser(String pairDelimiter, String keyValueDelimiter) {
        this.pairDelimiter = pairDelimiter;
        this.keyValueDelimiter = keyValueDelimiter;
    }

    private static class Extractor<T> {
        private final Consumer<T> callback;
        private final Function<String, T> converter;

        private void process(String value) {
            this.callback.accept(this.converter.apply(value));
        }

        @ConstructorProperties(value={"callback", "converter"})
        @SuppressFBWarnings(justification="generated code")
        public Extractor(Consumer<T> callback, Function<String, T> converter) {
            this.callback = callback;
            this.converter = converter;
        }
    }
}

