/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import io.pravega.common.hash.HashHelper;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.ByteArraySegment;

public class HashedArray
extends ByteArraySegment {
    private static final HashHelper HASH = HashHelper.seededWith(HashedArray.class.getName());
    private final int hashCode;

    public HashedArray(byte[] array) {
        super(array, 0, array.length);
        this.hashCode = HASH.hash(array, 0, array.length);
    }

    public HashedArray(ArrayView array) {
        super(array.array(), array.arrayOffset(), array.getLength());
        this.hashCode = HashedArray.hashCode(array);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static int hashCode(ArrayView array) {
        return HASH.hash(array.array(), array.arrayOffset(), array.getLength());
    }

    public boolean equals(Object obj) {
        if (obj instanceof HashedArray) {
            HashedArray ha = (HashedArray)obj;
            return this.hashCode == ha.hashCode && HashedArray.arrayEquals(this, ha);
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("Length=%d, Hash=%d", this.getLength(), this.hashCode);
    }

    public static boolean arrayEquals(ArrayView av1, ArrayView av2) {
        int len = av1.getLength();
        if (len != av2.getLength()) {
            return false;
        }
        byte[] a1 = av1.array();
        int o1 = av1.arrayOffset();
        byte[] a2 = av2.array();
        int o2 = av2.arrayOffset();
        for (int i = 0; i < len; ++i) {
            if (a1[o1 + i] == a2[o2 + i]) continue;
            return false;
        }
        return true;
    }
}

