/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.ReusableLatch;
import java.beans.ConstructorProperties;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class OrderedItemProcessor<ItemType, ResultType>
implements AutoCloseable {
    private static final int CLOSE_TIMEOUT_MILLIS = 60000;
    private final int capacity;
    @GuardedBy(value="processingLock")
    private final Function<ItemType, CompletableFuture<ResultType>> processor;
    @GuardedBy(value="stateLock")
    private final Deque<QueueItem> pendingItems;
    private final Executor executor;
    private final Object stateLock = new Object();
    private final Object processingLock = new Object();
    @GuardedBy(value="stateLock")
    private int activeCount;
    @GuardedBy(value="stateLock")
    private boolean closed;
    @GuardedBy(value="stateLock")
    private ReusableLatch emptyNotifier;

    public OrderedItemProcessor(int capacity, Function<ItemType, CompletableFuture<ResultType>> processor, Executor executor) {
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"capacity must be a non-negative number.");
        this.capacity = capacity;
        this.processor = (Function)Preconditions.checkNotNull(processor, (Object)"processor");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.pendingItems = new ArrayDeque<QueueItem>();
        this.activeCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ReusableLatch waitSignal = null;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.activeCount != 0 || !this.pendingItems.isEmpty()) {
                waitSignal = this.emptyNotifier = new ReusableLatch(false);
            }
        }
        if (waitSignal != null) {
            waitSignal.await(60000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<ResultType> process(ItemType item) {
        Preconditions.checkNotNull(item, (Object)"item");
        CompletableFuture<Object> result = null;
        Object object = this.stateLock;
        synchronized (object) {
            Exceptions.checkNotClosed(this.closed, this);
            if (this.hasCapacity() && this.pendingItems.isEmpty()) {
                ++this.activeCount;
            } else {
                result = new CompletableFuture();
                this.pendingItems.add(new QueueItem(item, result));
            }
        }
        if (result == null) {
            object = this.processingLock;
            synchronized (object) {
                result = this.processInternal(item);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void executionComplete(Throwable exception) {
        ArrayList<QueueItem> toFail = null;
        ProcessingException failEx = null;
        Object object = this.stateLock;
        synchronized (object) {
            --this.activeCount;
            if (exception != null && !this.closed) {
                failEx = new ProcessingException("A previous item failed to commit. Cannot process new items.", exception);
                toFail = new ArrayList<QueueItem>(this.pendingItems);
                this.pendingItems.clear();
                this.closed = true;
            }
            if (this.emptyNotifier != null && this.activeCount == 0 && this.pendingItems.isEmpty()) {
                this.emptyNotifier.release();
                this.emptyNotifier = null;
            }
        }
        if (toFail != null) {
            for (QueueItem q : toFail) {
                q.result.completeExceptionally(failEx);
            }
            return;
        }
        object = this.processingLock;
        synchronized (object) {
            while (true) {
                QueueItem toProcess;
                Object object2 = this.stateLock;
                synchronized (object2) {
                    if (this.hasCapacity() && !this.pendingItems.isEmpty()) {
                        toProcess = this.pendingItems.pollFirst();
                        ++this.activeCount;
                    } else {
                        break;
                    }
                }
                Futures.completeAfter(() -> this.processInternal(toProcess.data), toProcess.result);
            }
        }
    }

    @GuardedBy(value="processingLock")
    private CompletableFuture<ResultType> processInternal(ItemType data) {
        try {
            CompletableFuture<ResultType> result = this.processor.apply(data);
            result.whenCompleteAsync((r, ex) -> this.executionComplete((Throwable)ex), this.executor);
            return result;
        }
        catch (Throwable ex2) {
            if (!Exceptions.mustRethrow(ex2)) {
                this.executionComplete(ex2);
            }
            throw ex2;
        }
    }

    @GuardedBy(value="stateLock")
    private boolean hasCapacity() {
        return this.activeCount < this.capacity;
    }

    private class QueueItem {
        final ItemType data;
        final CompletableFuture<ResultType> result;

        @ConstructorProperties(value={"data", "result"})
        @SuppressFBWarnings(justification="generated code")
        public QueueItem(ItemType data, CompletableFuture<ResultType> result) {
            this.data = data;
            this.result = result;
        }
    }

    public static class ProcessingException
    extends IllegalStateException {
        private static final long serialVersionUID = 1L;

        private ProcessingException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

