/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;

public class Property<T> {
    private final String name;
    private final T defaultValue;

    public static <T> Property<T> named(String name) {
        return new Property<Object>(name, null);
    }

    public static <T> Property<T> named(String name, T defaultValue) {
        return new Property<T>(name, defaultValue);
    }

    boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public String toString() {
        return this.name;
    }

    @ConstructorProperties(value={"name", "defaultValue"})
    @SuppressFBWarnings(justification="generated code")
    private Property(String name, T defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Property)) {
            return false;
        }
        Property other = (Property)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        T this$defaultValue = this.getDefaultValue();
        T other$defaultValue = other.getDefaultValue();
        return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof Property;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        T $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    public T getDefaultValue() {
        return this.defaultValue;
    }
}

