/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReusableFutureLatch<T> {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(ReusableFutureLatch.class);
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final ArrayList<CompletableFuture<T>> waitingFutures = new ArrayList();
    @GuardedBy(value="lock")
    private T result;
    @GuardedBy(value="lock")
    private Throwable e;
    @GuardedBy(value="lock")
    private boolean released = false;
    @GuardedBy(value="lock")
    private Long runningThreadId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(CompletableFuture<T> toNotify) {
        Throwable e;
        T result;
        Object object = this.lock;
        synchronized (object) {
            if (!this.released) {
                this.waitingFutures.add(toNotify);
                return;
            }
            result = this.result;
            e = this.e;
        }
        if (e == null) {
            toNotify.complete(result);
        } else {
            toNotify.completeExceptionally(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAndRunReleaser(Runnable willCallRelease, CompletableFuture<T> toNotify) {
        boolean run = false;
        boolean complete = false;
        Object result = null;
        Throwable e = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.released) {
                complete = true;
                result = this.result;
                e = this.e;
            } else {
                this.waitingFutures.add(toNotify);
                if (this.runningThreadId == null) {
                    run = true;
                    this.runningThreadId = Thread.currentThread().getId();
                }
            }
        }
        if (run) {
            log.debug("Running releaser now, runningThread:{}", (Object)Thread.currentThread().getName());
            boolean success = false;
            try {
                willCallRelease.run();
                success = true;
            }
            finally {
                if (!success) {
                    Object object2 = this.lock;
                    synchronized (object2) {
                        if (this.runningThreadId != null && this.runningThreadId.longValue() == Thread.currentThread().getId()) {
                            this.runningThreadId = null;
                        }
                    }
                }
            }
        }
        if (complete) {
            if (e == null) {
                toNotify.complete(result);
            } else {
                toNotify.completeExceptionally(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(T result) {
        ArrayList<CompletableFuture<T>> toComplete = null;
        Iterator<CompletableFuture<T>> iterator = this.lock;
        synchronized (iterator) {
            if (!this.waitingFutures.isEmpty()) {
                toComplete = new ArrayList<CompletableFuture<T>>(this.waitingFutures);
                this.waitingFutures.clear();
            }
            this.e = null;
            this.result = result;
            this.released = true;
        }
        if (toComplete != null) {
            for (CompletableFuture<T> f : toComplete) {
                f.complete(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseExceptionally(Throwable e) {
        ArrayList<CompletableFuture<T>> toComplete = null;
        Iterator<CompletableFuture<T>> iterator = this.lock;
        synchronized (iterator) {
            if (!this.waitingFutures.isEmpty()) {
                toComplete = new ArrayList<CompletableFuture<T>>(this.waitingFutures);
                this.waitingFutures.clear();
            }
            this.e = e;
            this.result = null;
            this.released = true;
        }
        if (toComplete != null) {
            for (CompletableFuture<T> f : toComplete) {
                f.completeExceptionally(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.released = false;
            this.e = null;
            this.result = null;
            this.runningThreadId = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseExceptionallyAndReset(Throwable e) {
        ArrayList<CompletableFuture<T>> toComplete = null;
        Iterator<CompletableFuture<T>> iterator = this.lock;
        synchronized (iterator) {
            if (!this.waitingFutures.isEmpty()) {
                toComplete = new ArrayList<CompletableFuture<T>>(this.waitingFutures);
                this.waitingFutures.clear();
            }
            this.released = false;
            this.e = null;
            this.result = null;
            this.runningThreadId = null;
        }
        if (toComplete != null) {
            for (CompletableFuture<T> f : toComplete) {
                f.completeExceptionally(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return "Released: " + this.released + " waiting: " + this.waitingFutures.size() + " running: " + (this.runningThreadId != null);
        }
    }
}

