/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import com.google.common.base.Preconditions;
import io.pravega.common.Exceptions;
import io.pravega.common.util.ConfigurationException;
import io.pravega.common.util.InvalidPropertyValueException;
import io.pravega.common.util.MissingPropertyException;
import io.pravega.common.util.Property;
import java.util.Properties;
import java.util.function.Function;

public class TypedProperties {
    private static final String SEPARATOR = ".";
    private final String keyPrefix;
    private final Properties properties;

    public TypedProperties(Properties properties, String namespace) {
        Preconditions.checkNotNull((Object)properties, (Object)"properties");
        Exceptions.checkNotNullOrEmpty(namespace, "namespace");
        this.properties = properties;
        this.keyPrefix = namespace + SEPARATOR;
    }

    public String get(Property<String> property) throws ConfigurationException {
        return this.tryGet(property, s -> s);
    }

    public int getInt(Property<Integer> property) throws ConfigurationException {
        return this.tryGet(property, Integer::parseInt);
    }

    public long getLong(Property<Long> property) throws ConfigurationException {
        return this.tryGet(property, Long::parseLong);
    }

    public <T extends Enum<T>> T getEnum(Property<T> property, Class<T> enumClass) throws ConfigurationException {
        return (T)this.tryGet(property, s -> Enum.valueOf(enumClass, s));
    }

    public boolean getBoolean(Property<Boolean> property) throws ConfigurationException {
        return this.tryGet(property, this::parseBoolean);
    }

    private <T> T tryGet(Property<T> property, Function<String, T> converter) {
        String fullKeyName = this.keyPrefix + property.getName();
        String value = this.properties.getProperty(fullKeyName, null);
        if (value == null) {
            if (property.hasDefaultValue()) {
                return property.getDefaultValue();
            }
            throw new MissingPropertyException(fullKeyName);
        }
        try {
            return converter.apply(value.trim());
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidPropertyValueException(fullKeyName, value, ex);
        }
    }

    private boolean parseBoolean(String value) {
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("1")) {
            return true;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no") || value.equalsIgnoreCase("0")) {
            return false;
        }
        throw new IllegalArgumentException(String.format("String '%s' cannot be interpreted as a valid Boolean.", value));
    }
}

