/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util.btree;

import io.pravega.common.util.ByteArraySegment;
import java.io.Serializable;
import java.util.Comparator;

final class ByteArrayComparator
implements Comparator<byte[]>,
Serializable {
    static final byte MIN_VALUE = 0;
    static final byte MAX_VALUE = -1;
    private static final long serialVersionUID = 1L;

    ByteArrayComparator() {
    }

    @Override
    public int compare(byte[] b1, byte[] b2) {
        assert (b1.length == b2.length);
        return this.compare(b1, 0, b2, 0, b1.length);
    }

    @Override
    int compare(ByteArraySegment b1, ByteArraySegment b2) {
        assert (b1.getLength() == b2.getLength());
        return this.compare(b1.array(), b1.arrayOffset(), b2.array(), b2.arrayOffset(), b1.getLength());
    }

    int compare(byte[] b1, int offset1, byte[] b2, int offset2, int length) {
        for (int i = 0; i < length; ++i) {
            int r = (b1[offset1 + i] & 0xFF) - (b2[offset2 + i] & 0xFF);
            if (r == 0) continue;
            return r;
        }
        return 0;
    }
}

