/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util.btree;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ByteArraySegment;
import java.beans.ConstructorProperties;
import lombok.NonNull;

public class PageEntry {
    @NonNull
    private final ByteArraySegment key;
    private final ByteArraySegment value;

    static PageEntry noValue(ByteArraySegment key) {
        return new PageEntry(key, null);
    }

    boolean hasValue() {
        return this.value != null;
    }

    public String toString() {
        return String.format("KeyLength = %s, ValueLength = %s", this.key.getLength(), this.value == null ? "[NO VALUE]" : Integer.valueOf(this.value.getLength()));
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    public ByteArraySegment getKey() {
        return this.key;
    }

    @SuppressFBWarnings(justification="generated code")
    public ByteArraySegment getValue() {
        return this.value;
    }

    @ConstructorProperties(value={"key", "value"})
    @SuppressFBWarnings(justification="generated code")
    public PageEntry(@NonNull ByteArraySegment key, ByteArraySegment value) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        this.key = key;
        this.value = value;
    }
}

