/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.metrics;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.micrometer.core.instrument.Meter;
import io.pravega.common.Exceptions;
import io.pravega.shared.metrics.Metric;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

abstract class MetricProxy<T extends Metric>
implements AutoCloseable {
    private final AtomicReference<T> instance = new AtomicReference();
    private final String proxyName;
    private final Consumer<String> closeCallback;

    MetricProxy(T instance, String proxyName, Consumer<String> closeCallback) {
        this.closeCallback = (Consumer)Preconditions.checkNotNull(closeCallback, (Object)"closeCallback");
        this.proxyName = Exceptions.checkNotNullOrEmpty((String)proxyName, (String)"name");
        this.updateInstance(instance);
    }

    @Override
    public void close() {
        T i = this.getInstance();
        if (i != null) {
            i.close();
            this.closeCallback.accept(this.proxyName);
        }
    }

    public Meter.Id getId() {
        return this.getInstance().getId();
    }

    void updateInstance(T instance) {
        Metric oldInstance = (Metric)this.instance.getAndSet(Preconditions.checkNotNull(instance, (Object)"instance"));
        if (oldInstance != null && oldInstance != instance) {
            oldInstance.close();
        }
    }

    protected T getInstance() {
        return (T)((Metric)this.instance.get());
    }

    @SuppressFBWarnings(justification="generated code")
    public String getProxyName() {
        return this.proxyName;
    }
}

