/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.metrics;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.micrometer.influx.InfluxConfig;
import io.micrometer.statsd.StatsdConfig;
import io.micrometer.statsd.StatsdFlavor;
import io.pravega.shared.metrics.MetricsConfig;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryConfigUtil {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(RegistryConfigUtil.class);

    public static StatsdConfig createStatsDConfig(final MetricsConfig conf) {
        log.info("Configuring stats with statsD at {}:{}", (Object)conf.getStatsDHost(), (Object)conf.getStatsDPort());
        return new StatsdConfig(){

            public Duration step() {
                return Duration.ofSeconds(conf.getOutputFrequencySeconds().getSeconds());
            }

            public String prefix() {
                return conf.getMetricsPrefix();
            }

            public String host() {
                return conf.getStatsDHost();
            }

            public int port() {
                return conf.getStatsDPort();
            }

            public StatsdFlavor flavor() {
                return StatsdFlavor.TELEGRAF;
            }

            public String get(String key) {
                return null;
            }
        };
    }

    public static InfluxConfig createInfluxConfig(final MetricsConfig conf) {
        log.info("Configuring stats with direct InfluxDB at {}", (Object)conf.getInfluxDBUri());
        return new InfluxConfig(){

            public Duration step() {
                return Duration.ofSeconds(conf.getOutputFrequencySeconds().getSeconds());
            }

            public String prefix() {
                return conf.getMetricsPrefix();
            }

            public String uri() {
                return conf.getInfluxDBUri();
            }

            public String db() {
                return conf.getInfluxDBName();
            }

            public String userName() {
                return conf.getInfluxDBUserName();
            }

            public String password() {
                return String.valueOf(conf.getInfluxDBPassword());
            }

            public String retentionPolicy() {
                return conf.getInfluxDBRetention();
            }

            public String get(String k) {
                return null;
            }
        };
    }
}

