/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client;

import com.google.common.annotations.Beta;
import io.pravega.client.ClientConfig;
import io.pravega.client.batch.SegmentIterator;
import io.pravega.client.batch.SegmentRange;
import io.pravega.client.batch.StreamSegmentsIterator;
import io.pravega.client.batch.impl.BatchClientFactoryImpl;
import io.pravega.client.netty.impl.ConnectionFactoryImpl;
import io.pravega.client.stream.Serializer;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.StreamCut;
import io.pravega.client.stream.impl.ControllerImpl;
import io.pravega.client.stream.impl.ControllerImplConfig;

@Beta
public interface BatchClientFactory
extends AutoCloseable {
    public static BatchClientFactory withScope(String scope, ClientConfig config) {
        ConnectionFactoryImpl connectionFactory = new ConnectionFactoryImpl(config);
        ControllerImpl controller = new ControllerImpl(ControllerImplConfig.builder().clientConfig(config).build(), connectionFactory.getInternalExecutor());
        return new BatchClientFactoryImpl(controller, connectionFactory);
    }

    public StreamSegmentsIterator getSegments(Stream var1, StreamCut var2, StreamCut var3);

    public <T> SegmentIterator<T> readSegment(SegmentRange var1, Serializer<T> var2);

    @Override
    public void close();
}

