/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.admin.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.netty.impl.ConnectionFactory;
import io.pravega.client.security.auth.DelegationTokenProvider;
import io.pravega.client.security.auth.DelegationTokenProviderFactory;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.segment.impl.SegmentInfo;
import io.pravega.client.segment.impl.SegmentMetadataClient;
import io.pravega.client.segment.impl.SegmentMetadataClientFactory;
import io.pravega.client.segment.impl.SegmentMetadataClientFactoryImpl;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.StreamCut;
import io.pravega.client.stream.impl.Controller;
import io.pravega.client.stream.impl.StreamCutImpl;
import io.pravega.client.stream.impl.StreamImpl;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamCutHelper {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(StreamCutHelper.class);
    private final Controller controller;
    private final SegmentMetadataClientFactory segmentMetadataClientFactory;

    public StreamCutHelper(Controller controller, ConnectionFactory connectionFactory) {
        this.controller = controller;
        this.segmentMetadataClientFactory = new SegmentMetadataClientFactoryImpl(controller, connectionFactory);
    }

    public CompletableFuture<StreamCut> fetchHeadStreamCut(Stream stream) {
        return this.controller.getSegmentsAtTime(new StreamImpl(stream.getScope(), stream.getStreamName()), 0L).thenApply(s -> new StreamCutImpl(stream, (Map<Segment, Long>)s));
    }

    public CompletableFuture<StreamCut> fetchTailStreamCut(Stream stream) {
        DelegationTokenProvider tokenProvider = DelegationTokenProviderFactory.create(this.controller, stream.getScope(), stream.getStreamName());
        return this.controller.getCurrentSegments(stream.getScope(), stream.getStreamName()).thenApply(streamsegments -> {
            tokenProvider.populateToken(streamsegments.getDelegationToken());
            Map<Segment, Long> pos = streamsegments.getSegments().stream().map(segment -> this.segmentToInfo((Segment)segment, tokenProvider)).collect(Collectors.toMap(SegmentInfo::getSegment, SegmentInfo::getWriteOffset));
            return new StreamCutImpl(stream, pos);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentInfo segmentToInfo(Segment s, DelegationTokenProvider tokenProvider) {
        SegmentMetadataClient client = this.segmentMetadataClientFactory.createSegmentMetadataClient(s, tokenProvider);
        try {
            SegmentInfo segmentInfo = client.getSegmentInfo();
            return segmentInfo;
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }
}

