/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.batch.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.BatchClientFactory;
import io.pravega.client.admin.impl.StreamCutHelper;
import io.pravega.client.admin.impl.StreamManagerImpl;
import io.pravega.client.batch.BatchClient;
import io.pravega.client.batch.SegmentIterator;
import io.pravega.client.batch.SegmentRange;
import io.pravega.client.batch.StreamInfo;
import io.pravega.client.batch.StreamSegmentsIterator;
import io.pravega.client.batch.impl.SegmentIteratorImpl;
import io.pravega.client.batch.impl.SegmentRangeImpl;
import io.pravega.client.batch.impl.StreamSegmentsInfoImpl;
import io.pravega.client.netty.impl.ConnectionFactory;
import io.pravega.client.security.auth.DelegationTokenProviderFactory;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.segment.impl.SegmentInfo;
import io.pravega.client.segment.impl.SegmentInputStreamFactory;
import io.pravega.client.segment.impl.SegmentInputStreamFactoryImpl;
import io.pravega.client.segment.impl.SegmentMetadataClient;
import io.pravega.client.segment.impl.SegmentMetadataClientFactory;
import io.pravega.client.segment.impl.SegmentMetadataClientFactoryImpl;
import io.pravega.client.stream.Serializer;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.StreamCut;
import io.pravega.client.stream.impl.Controller;
import io.pravega.client.stream.impl.StreamSegmentSuccessors;
import io.pravega.common.concurrent.Futures;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class BatchClientFactoryImpl
implements BatchClientFactory,
BatchClient {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(BatchClientFactoryImpl.class);
    private final Controller controller;
    private final ConnectionFactory connectionFactory;
    private final SegmentInputStreamFactory inputStreamFactory;
    private final SegmentMetadataClientFactory segmentMetadataClientFactory;
    private final StreamCutHelper streamCutHelper;
    @GuardedBy(value="this")
    private final AtomicReference<String> latestDelegationToken;

    public BatchClientFactoryImpl(Controller controller, ConnectionFactory connectionFactory) {
        this.controller = controller;
        this.connectionFactory = connectionFactory;
        this.inputStreamFactory = new SegmentInputStreamFactoryImpl(controller, connectionFactory);
        this.segmentMetadataClientFactory = new SegmentMetadataClientFactoryImpl(controller, connectionFactory);
        this.streamCutHelper = new StreamCutHelper(controller, connectionFactory);
        this.latestDelegationToken = new AtomicReference();
    }

    @Override
    @Deprecated
    public CompletableFuture<StreamInfo> getStreamInfo(Stream stream) {
        Preconditions.checkNotNull((Object)stream, (Object)"stream");
        StreamManagerImpl streamManager = new StreamManagerImpl(this.controller, this.connectionFactory);
        return streamManager.getStreamInfo(stream).thenApply(info -> new StreamInfo(info.getScope(), info.getStreamName(), info.getTailStreamCut(), info.getHeadStreamCut()));
    }

    @Override
    public StreamSegmentsIterator getSegments(Stream stream, StreamCut fromStreamCut, StreamCut toStreamCut) {
        Preconditions.checkNotNull((Object)stream, (Object)"stream");
        return this.listSegments(stream, Optional.ofNullable(fromStreamCut), Optional.ofNullable(toStreamCut));
    }

    @Override
    public <T> SegmentIterator<T> readSegment(SegmentRange segment, Serializer<T> deserializer) {
        return new SegmentIteratorImpl<T>(this.inputStreamFactory, segment.asImpl().getSegment(), deserializer, segment.asImpl().getStartOffset(), segment.asImpl().getEndOffset());
    }

    private StreamSegmentsIterator listSegments(Stream stream, Optional<StreamCut> startStreamCut, Optional<StreamCut> endStreamCut) {
        Optional<StreamCut> startCut = startStreamCut.filter(sc -> !sc.equals(StreamCut.UNBOUNDED));
        Optional<StreamCut> endCut = endStreamCut.filter(sc -> !sc.equals(StreamCut.UNBOUNDED));
        startCut.ifPresent(streamCut -> Preconditions.checkArgument((boolean)stream.equals(streamCut.asImpl().getStream())));
        endCut.ifPresent(streamCut -> Preconditions.checkArgument((boolean)stream.equals(streamCut.asImpl().getStream())));
        CompletableFuture<StreamCut> startSCFuture = startCut.isPresent() ? CompletableFuture.completedFuture(startCut.get()) : this.streamCutHelper.fetchHeadStreamCut(stream);
        CompletableFuture<StreamCut> endSCFuture = endCut.isPresent() ? CompletableFuture.completedFuture(endCut.get()) : this.streamCutHelper.fetchTailStreamCut(stream);
        CompletionStage streamSegmentInfo = startSCFuture.thenCombine(endSCFuture, (startSC, endSC) -> this.getStreamSegmentInfo((StreamCut)startSC, (StreamCut)endSC));
        return (StreamSegmentsIterator)Futures.getAndHandleExceptions((Future)((Object)streamSegmentInfo), RuntimeException::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamSegmentsIterator getStreamSegmentInfo(StreamCut startStreamCut, StreamCut endStreamCut) {
        log.debug("Start stream cut: {}, End stream cut: {}", (Object)startStreamCut, (Object)endStreamCut);
        StreamSegmentsInfoImpl.validateStreamCuts(startStreamCut, endStreamCut);
        TreeSet<Segment> segmentSet = new TreeSet<Segment>();
        StreamSegmentSuccessors segments = (StreamSegmentSuccessors)Futures.getAndHandleExceptions(this.controller.getSegments(startStreamCut, endStreamCut), RuntimeException::new);
        segmentSet.addAll(segments.getSegments());
        BatchClientFactoryImpl batchClientFactoryImpl = this;
        synchronized (batchClientFactoryImpl) {
            this.latestDelegationToken.set(segments.getDelegationToken());
        }
        log.debug("List of Segments between the start and end stream cuts : {}", segmentSet);
        Iterator iterator = Iterators.transform(segmentSet.iterator(), s -> this.getSegmentRange((Segment)s, startStreamCut, endStreamCut));
        return StreamSegmentsInfoImpl.builder().segmentRangeIterator(iterator).startStreamCut(startStreamCut).endStreamCut(endStreamCut).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentInfo segmentToInfo(Segment s) {
        String delegationToken;
        BatchClientFactoryImpl batchClientFactoryImpl = this;
        synchronized (batchClientFactoryImpl) {
            delegationToken = this.latestDelegationToken.get();
        }
        SegmentMetadataClient client = this.segmentMetadataClientFactory.createSegmentMetadataClient(s, DelegationTokenProviderFactory.create(delegationToken, this.controller, s));
        try {
            SegmentInfo segmentInfo = client.getSegmentInfo();
            return segmentInfo;
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    private SegmentRange getSegmentRange(Segment segment, StreamCut startStreamCut, StreamCut endStreamCut) {
        SegmentRangeImpl.SegmentRangeImplBuilder segmentRangeBuilder = SegmentRangeImpl.builder().segment(segment);
        if (startStreamCut.asImpl().getPositions().containsKey(segment) && endStreamCut.asImpl().getPositions().containsKey(segment)) {
            segmentRangeBuilder.startOffset(startStreamCut.asImpl().getPositions().get(segment)).endOffset(endStreamCut.asImpl().getPositions().get(segment));
        } else {
            SegmentInfo r = this.segmentToInfo(segment);
            segmentRangeBuilder.startOffset(startStreamCut.asImpl().getPositions().getOrDefault(segment, r.getStartingOffset())).endOffset(endStreamCut.asImpl().getPositions().getOrDefault(segment, r.getWriteOffset()));
        }
        return segmentRangeBuilder.build();
    }

    @Override
    public void close() {
        this.controller.close();
        this.connectionFactory.close();
    }
}

