/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.byteStream.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.byteStream.ByteStreamReader;
import io.pravega.client.segment.impl.EndOfSegmentException;
import io.pravega.client.segment.impl.SegmentInputStream;
import io.pravega.client.segment.impl.SegmentMetadataClient;
import io.pravega.common.Exceptions;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;

public class ByteStreamReaderImpl
extends ByteStreamReader {
    @NonNull
    private final SegmentInputStream input;
    @NonNull
    private final SegmentMetadataClient meta;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    @Override
    public boolean isOpen() {
        return !this.closed.get();
    }

    @Override
    public long getOffset() {
        return this.input.getOffset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seekToOffset(long offset) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        SegmentInputStream segmentInputStream = this.input;
        synchronized (segmentInputStream) {
            this.input.setOffset(offset);
        }
    }

    @Override
    public int available() {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        return this.input.bytesInBuffer();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.input.close();
        }
    }

    @Override
    public long fetchTailOffset() {
        return this.meta.fetchCurrentSegmentLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        try {
            SegmentInputStream segmentInputStream = this.input;
            synchronized (segmentInputStream) {
                return this.input.read(dst, Long.MAX_VALUE);
            }
        }
        catch (EndOfSegmentException e) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        ByteBuffer buffer = ByteBuffer.allocate(1);
        try {
            int read;
            SegmentInputStream segmentInputStream = this.input;
            synchronized (segmentInputStream) {
                read = this.input.read(buffer, Long.MAX_VALUE);
            }
            if (read > 0) {
                buffer.flip();
                return buffer.get() & 0xFF;
            }
            return read;
        }
        catch (EndOfSegmentException e) {
            return -1;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(ByteBuffer.wrap(b));
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.read(ByteBuffer.wrap(b, off, len));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long toSkip) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        long endOffset = this.fetchTailOffset();
        SegmentInputStream segmentInputStream = this.input;
        synchronized (segmentInputStream) {
            long offset = this.input.getOffset();
            long newOffset = Math.min(offset + toSkip, endOffset);
            this.input.setOffset(newOffset);
            return newOffset - offset;
        }
    }

    @Override
    public CompletableFuture<Integer> onDataAvailable() {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        return this.input.fillBuffer().thenApply(v -> this.available());
    }

    @ConstructorProperties(value={"input", "meta"})
    @SuppressFBWarnings(justification="generated code")
    public ByteStreamReaderImpl(@NonNull SegmentInputStream input, @NonNull SegmentMetadataClient meta) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (meta == null) {
            throw new NullPointerException("meta is marked @NonNull but is null");
        }
        this.input = input;
        this.meta = meta;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "ByteStreamReaderImpl(input=" + this.input + ", meta=" + this.meta + ", closed=" + this.closed + ")";
    }
}

