/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.netty.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.ClientConfig;
import io.pravega.client.netty.impl.ClientConnection;
import io.pravega.client.netty.impl.ConnectionFactory;
import io.pravega.client.netty.impl.ConnectionPool;
import io.pravega.client.netty.impl.ConnectionPoolImpl;
import io.pravega.client.netty.impl.Flow;
import io.pravega.common.concurrent.ExecutorServiceHelpers;
import io.pravega.shared.protocol.netty.PravegaNodeUri;
import io.pravega.shared.protocol.netty.ReplyProcessor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionFactoryImpl
implements ConnectionFactory {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(ConnectionFactoryImpl.class);
    private static final AtomicInteger POOLCOUNT = new AtomicInteger();
    private final ClientConfig clientConfig;
    private final ScheduledExecutorService executor;
    @VisibleForTesting
    private final ConnectionPool connectionPool;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public ConnectionFactoryImpl(ClientConfig clientConfig) {
        this(clientConfig, (ConnectionPool)new ConnectionPoolImpl(clientConfig), (Integer)null);
    }

    @VisibleForTesting
    public ConnectionFactoryImpl(ClientConfig clientConfig, ConnectionPool connectionPool, Integer numThreadsInPool) {
        this.clientConfig = (ClientConfig)Preconditions.checkNotNull((Object)clientConfig, (Object)"clientConfig");
        this.connectionPool = (ConnectionPool)Preconditions.checkNotNull((Object)connectionPool);
        this.executor = ExecutorServiceHelpers.newScheduledThreadPool((int)this.getThreadPoolSize(numThreadsInPool), (String)("clientInternal-" + POOLCOUNT.incrementAndGet()));
    }

    @VisibleForTesting
    public ConnectionFactoryImpl(ClientConfig clientConfig, ConnectionPool connectionPool, ScheduledExecutorService executor) {
        this.clientConfig = (ClientConfig)Preconditions.checkNotNull((Object)clientConfig, (Object)"clientConfig");
        this.connectionPool = connectionPool;
        this.executor = executor;
    }

    @Override
    public CompletableFuture<ClientConnection> establishConnection(Flow flow, PravegaNodeUri endpoint, ReplyProcessor rp) {
        return this.connectionPool.getClientConnection(flow, endpoint, rp);
    }

    @Override
    public CompletableFuture<ClientConnection> establishConnection(PravegaNodeUri endpoint, ReplyProcessor rp) {
        return this.connectionPool.getClientConnection(endpoint, rp);
    }

    @Override
    public ScheduledExecutorService getInternalExecutor() {
        return this.executor;
    }

    @Override
    public void close() {
        log.info("Shutting down connection factory");
        if (this.closed.compareAndSet(false, true)) {
            ExecutorServiceHelpers.shutdown((ExecutorService[])new ExecutorService[]{this.executor});
            this.connectionPool.close();
        }
    }

    @VisibleForTesting
    public int getActiveChannelCount() {
        return this.connectionPool.getActiveChannelCount();
    }

    private int getThreadPoolSize(Integer threadCount) {
        if (threadCount != null) {
            return threadCount;
        }
        String configuredThreads = System.getProperty("pravega.client.internal.threadpool.size", null);
        if (configuredThreads != null) {
            return Integer.parseInt(configuredThreads);
        }
        return Runtime.getRuntime().availableProcessors();
    }

    @SuppressFBWarnings(justification="generated code")
    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }
}

