/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.netty.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.pravega.client.ClientConfig;
import io.pravega.client.netty.impl.ClientConnection;
import io.pravega.client.netty.impl.Connection;
import io.pravega.client.netty.impl.ConnectionPool;
import io.pravega.client.netty.impl.Flow;
import io.pravega.client.netty.impl.FlowHandler;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.shared.metrics.ClientMetricUpdater;
import io.pravega.shared.metrics.MetricListener;
import io.pravega.shared.metrics.MetricNotifier;
import io.pravega.shared.protocol.netty.CommandDecoder;
import io.pravega.shared.protocol.netty.CommandEncoder;
import io.pravega.shared.protocol.netty.ConnectionFailedException;
import io.pravega.shared.protocol.netty.ExceptionLoggingHandler;
import io.pravega.shared.protocol.netty.PravegaNodeUri;
import io.pravega.shared.protocol.netty.ReplyProcessor;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPoolImpl
implements ConnectionPool {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(ConnectionPoolImpl.class);
    @SuppressFBWarnings(justification="generated code")
    private final Object $lock = new Object[0];
    private static final Comparator<Connection> COMPARATOR = new Comparator<Connection>(){

        @Override
        public int compare(Connection c1, Connection c2) {
            int v1 = Futures.isSuccessful(c1.getConnected()) ? c1.getFlowCount() : Integer.MAX_VALUE;
            int v2 = Futures.isSuccessful(c2.getConnected()) ? c2.getFlowCount() : Integer.MAX_VALUE;
            return Integer.compare(v1, v2);
        }
    };
    private final ClientConfig clientConfig;
    private final EventLoopGroup group;
    private final MetricNotifier metricNotifier;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    @VisibleForTesting
    private final ChannelGroup channelGroup = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    @GuardedBy(value="$lock")
    private final Map<PravegaNodeUri, List<Connection>> connectionMap = new HashMap<PravegaNodeUri, List<Connection>>();

    public ConnectionPoolImpl(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.group = this.getEventLoopGroup();
        MetricListener metricListener = clientConfig.getMetricListener();
        this.metricNotifier = metricListener == null ? MetricNotifier.NO_OP_METRIC_NOTIFIER : new ClientMetricUpdater(metricListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<ClientConnection> getClientConnection(Flow flow, PravegaNodeUri location, ReplyProcessor rp) {
        Object object = this.$lock;
        synchronized (object) {
            Connection connection2;
            Preconditions.checkNotNull((Object)flow, (Object)"Flow");
            Preconditions.checkNotNull((Object)location, (Object)"Location");
            Preconditions.checkNotNull((Object)rp, (Object)"ReplyProcessor");
            Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
            List connectionList = this.connectionMap.getOrDefault(location, new ArrayList());
            List prunedConnectionList = connectionList.stream().filter(connection -> !connection.getConnected().isDone() || Futures.isSuccessful(connection.getConnected()) && connection.getFlowHandler().isConnectionEstablished()).collect(Collectors.toList());
            log.debug("List of connections to {} that can be used: {}", (Object)location, prunedConnectionList);
            Optional<Connection> suggestedConnection = prunedConnectionList.stream().min(COMPARATOR);
            if (suggestedConnection.isPresent() && (prunedConnectionList.size() >= this.clientConfig.getMaxConnectionsPerSegmentStore() || this.isUnused(suggestedConnection.get()))) {
                log.info("Reusing connection: {}", (Object)suggestedConnection.get());
                connection2 = suggestedConnection.get();
            } else {
                log.info("Creating a new connection to {}", (Object)location);
                FlowHandler handler = new FlowHandler(location.getEndpoint(), this.metricNotifier);
                CompletableFuture<Void> establishedFuture = this.establishConnection(location, handler);
                connection2 = new Connection(location, handler, establishedFuture);
                prunedConnectionList.add(connection2);
            }
            ClientConnection result = connection2.getFlowHandler().createFlow(flow, rp);
            this.connectionMap.put(location, prunedConnectionList);
            return connection2.getConnected().thenApply(v -> result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<ClientConnection> getClientConnection(PravegaNodeUri location, ReplyProcessor rp) {
        Object object = this.$lock;
        synchronized (object) {
            Preconditions.checkNotNull((Object)location, (Object)"Location");
            Preconditions.checkNotNull((Object)rp, (Object)"ReplyProcessor");
            Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
            FlowHandler handler = new FlowHandler(location.getEndpoint(), this.metricNotifier);
            CompletableFuture<Void> connectedFuture = this.establishConnection(location, handler);
            Connection connection = new Connection(location, handler, connectedFuture);
            ClientConnection result = connection.getFlowHandler().createConnectionWithFlowDisabled(rp);
            return connectedFuture.thenApply(v -> result);
        }
    }

    private boolean isUnused(Connection connection) {
        return Futures.isSuccessful(connection.getConnected()) && connection.getFlowCount() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void pruneUnusedConnections() {
        Object object = this.$lock;
        synchronized (object) {
            for (List<Connection> connections : this.connectionMap.values()) {
                Iterator<Connection> iterator = connections.iterator();
                while (iterator.hasNext()) {
                    Connection connection = iterator.next();
                    if (!this.isUnused(connection)) continue;
                    connection.getFlowHandler().close();
                    iterator.remove();
                }
            }
        }
    }

    @Override
    public int getActiveChannelCount() {
        return this.getActiveChannels().size();
    }

    @VisibleForTesting
    public List<Channel> getActiveChannels() {
        return this.channelGroup.stream().filter(Channel::isActive).peek(ch -> log.debug("Channel with id {} localAddress {} and remoteAddress {} is active.", new Object[]{ch.id(), ch.localAddress(), ch.remoteAddress()})).collect(Collectors.toList());
    }

    private CompletableFuture<Void> establishConnection(PravegaNodeUri location, FlowHandler handler) {
        Bootstrap b = (Bootstrap)this.getNettyBootstrap().handler(this.getChannelInitializer(location, handler));
        CompletableFuture connectionComplete = new CompletableFuture();
        try {
            b.connect(location.getEndpoint(), location.getPort()).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    Channel ch = future.channel();
                    log.debug("Connect operation completed for channel:{}, local address:{}, remote address:{}", new Object[]{ch.id(), ch.localAddress(), ch.remoteAddress()});
                    this.channelGroup.add((Object)ch);
                    connectionComplete.complete(null);
                } else {
                    connectionComplete.completeExceptionally((Throwable)new ConnectionFailedException(future.cause()));
                }
            }));
        }
        catch (Exception e) {
            connectionComplete.completeExceptionally((Throwable)new ConnectionFailedException((Throwable)e));
        }
        return connectionComplete.thenCompose(v -> {
            CompletableFuture<Void> channelRegisteredFuture = new CompletableFuture<Void>();
            handler.completeWhenRegistered(channelRegisteredFuture);
            return channelRegisteredFuture;
        });
    }

    private Bootstrap getNettyBootstrap() {
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)b.group(this.group)).channel(Epoll.isAvailable() ? EpollSocketChannel.class : NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true);
        return b;
    }

    @VisibleForTesting
    ChannelInitializer<SocketChannel> getChannelInitializer(final PravegaNodeUri location, final FlowHandler handler) {
        final SslContext sslCtx = this.getSslContext();
        return new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                if (sslCtx != null) {
                    SslHandler sslHandler = sslCtx.newHandler(ch.alloc(), location.getEndpoint(), location.getPort());
                    if (ConnectionPoolImpl.this.clientConfig.isValidateHostName()) {
                        SSLEngine sslEngine = sslHandler.engine();
                        SSLParameters sslParameters = sslEngine.getSSLParameters();
                        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
                        sslEngine.setSSLParameters(sslParameters);
                    }
                    p.addLast(new ChannelHandler[]{sslHandler});
                }
                ChannelHandler[] channelHandlerArray = new ChannelHandler[5];
                channelHandlerArray[0] = new ExceptionLoggingHandler(location.getEndpoint());
                channelHandlerArray[1] = new CommandEncoder(handler::getAppendBatchSizeTracker, ConnectionPoolImpl.this.metricNotifier);
                channelHandlerArray[2] = new LengthFieldBasedFrameDecoder(0x7FFFFF, 4, 4);
                channelHandlerArray[3] = new CommandDecoder();
                channelHandlerArray[4] = handler;
                p.addLast(channelHandlerArray);
            }
        };
    }

    @VisibleForTesting
    SslContext getSslContext() {
        SslContext sslCtx;
        if (this.clientConfig.isEnableTlsToSegmentStore()) {
            log.debug("Setting up an SSL/TLS Context");
            try {
                SslContextBuilder clientSslCtxBuilder = SslContextBuilder.forClient();
                if (Strings.isNullOrEmpty((String)this.clientConfig.getTrustStore())) {
                    log.debug("Client truststore wasn't specified.");
                    File clientTruststore = null;
                    clientSslCtxBuilder.trustManager(clientTruststore);
                } else {
                    clientSslCtxBuilder.trustManager(new File(this.clientConfig.getTrustStore()));
                    log.debug("Client truststore: {}", (Object)this.clientConfig.getTrustStore());
                }
                sslCtx = clientSslCtxBuilder.build();
            }
            catch (SSLException e) {
                throw new RuntimeException(e);
            }
        } else {
            sslCtx = null;
        }
        return sslCtx;
    }

    private EventLoopGroup getEventLoopGroup() {
        if (Epoll.isAvailable()) {
            return new EpollEventLoopGroup();
        }
        log.warn("Epoll not available. Falling back on NIO.");
        return new NioEventLoopGroup();
    }

    @Override
    public void close() {
        log.info("Shutting down connection pool");
        if (this.closed.compareAndSet(false, true)) {
            this.group.shutdownGracefully();
            this.metricNotifier.close();
        }
    }

    @SuppressFBWarnings(justification="generated code")
    ChannelGroup getChannelGroup() {
        return this.channelGroup;
    }
}

