/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.netty.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.ScheduledFuture;
import io.pravega.client.netty.impl.AppendBatchSizeTrackerImpl;
import io.pravega.client.netty.impl.ClientConnection;
import io.pravega.client.netty.impl.ClientConnectionImpl;
import io.pravega.client.netty.impl.Flow;
import io.pravega.client.stream.impl.ConnectionClosedException;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.ReusableFutureLatch;
import io.pravega.shared.metrics.ClientMetricKeys;
import io.pravega.shared.metrics.MetricNotifier;
import io.pravega.shared.protocol.netty.AppendBatchSizeTracker;
import io.pravega.shared.protocol.netty.ConnectionFailedException;
import io.pravega.shared.protocol.netty.Reply;
import io.pravega.shared.protocol.netty.ReplyProcessor;
import io.pravega.shared.protocol.netty.WireCommands;
import io.pravega.shared.segment.StreamSegmentNameUtils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowHandler
extends ChannelInboundHandlerAdapter
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(FlowHandler.class);
    private static final int FLOW_DISABLED = 0;
    private final String connectionName;
    private final MetricNotifier metricNotifier;
    private final AtomicReference<Channel> channel = new AtomicReference();
    private final AtomicReference<ScheduledFuture<?>> keepAliveFuture = new AtomicReference();
    private final AtomicBoolean recentMessage = new AtomicBoolean(false);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ReusableFutureLatch<Void> registeredFutureLatch = new ReusableFutureLatch();
    @VisibleForTesting
    private final ConcurrentHashMap<Integer, ReplyProcessor> flowIdReplyProcessorMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, AppendBatchSizeTracker> flowIDBatchSizeTrackerMap = new ConcurrentHashMap();
    private final AtomicBoolean disableFlow = new AtomicBoolean(false);

    public FlowHandler(String connectionName) {
        this(connectionName, MetricNotifier.NO_OP_METRIC_NOTIFIER);
    }

    public FlowHandler(String connectionName, MetricNotifier updateMetric) {
        this.connectionName = connectionName;
        this.metricNotifier = updateMetric;
    }

    public ClientConnection createFlow(Flow flow, ReplyProcessor rp) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        Preconditions.checkState((!this.disableFlow.get() ? 1 : 0) != 0, (Object)"Ensure flows are enabled.");
        int flowID = flow.getFlowId();
        log.info("Creating Flow {} for endpoint {}. The current Channel is {}.", new Object[]{flow.getFlowId(), this.connectionName, this.channel.get()});
        if (this.flowIdReplyProcessorMap.put(flowID, rp) != null) {
            throw new IllegalArgumentException("Multiple flows cannot be created with the same Flow id " + flowID);
        }
        this.createAppendBatchSizeTrackerIfNeeded(flowID);
        return new ClientConnectionImpl(this.connectionName, flowID, this);
    }

    public ClientConnection createConnectionWithFlowDisabled(ReplyProcessor rp) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        Preconditions.checkState((!this.disableFlow.getAndSet(true) ? 1 : 0) != 0, (Object)"Flows are disabled, incorrect usage pattern.");
        log.info("Creating a new connection with flow disabled for endpoint {}. The current Channel is {}.", (Object)this.connectionName, (Object)this.channel.get());
        this.flowIdReplyProcessorMap.put(0, rp);
        this.createAppendBatchSizeTrackerIfNeeded(0);
        return new ClientConnectionImpl(this.connectionName, 0, this);
    }

    public void closeFlow(ClientConnection clientConnection) {
        ClientConnectionImpl clientConnectionImpl = (ClientConnectionImpl)clientConnection;
        int flow = clientConnectionImpl.getFlowId();
        log.info("Closing Flow {} for endpoint {}", (Object)flow, (Object)clientConnectionImpl.getConnectionName());
        this.flowIdReplyProcessorMap.remove(flow);
        this.flowIDBatchSizeTrackerMap.remove(flow);
        if (flow == 0) {
            this.close();
        }
    }

    private void createAppendBatchSizeTrackerIfNeeded(int flowID) {
        if (this.flowIDBatchSizeTrackerMap.containsKey(flowID)) {
            log.debug("Reusing Batch size tracker for Flow ID {}.", (Object)flowID);
        } else {
            log.debug("Creating Batch size tracker for flow ID {}.", (Object)flowID);
            this.flowIDBatchSizeTrackerMap.put(flowID, new AppendBatchSizeTrackerImpl());
        }
    }

    public AppendBatchSizeTracker getAppendBatchSizeTracker(long requestID) {
        return this.flowIDBatchSizeTrackerMap.get(Flow.toFlowID(requestID));
    }

    public int getOpenFlowCount() {
        return this.flowIdReplyProcessorMap.size();
    }

    public boolean isConnectionEstablished() {
        return this.channel.get() != null;
    }

    Channel getChannel() throws ConnectionFailedException {
        Channel ch = this.channel.get();
        if (ch == null) {
            throw new ConnectionFailedException("Connection to " + this.connectionName + " is not established.");
        }
        return ch;
    }

    void setRecentMessage() {
        this.recentMessage.set(true);
    }

    void completeWhenRegistered(CompletableFuture<Void> future) {
        Preconditions.checkNotNull(future, (Object)"future");
        this.registeredFutureLatch.register(future);
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
        Channel ch = ctx.channel();
        this.channel.set(ch);
        log.info("Connection established with endpoint {} on channel {}", (Object)this.connectionName, (Object)ch);
        ch.write((Object)new WireCommands.Hello(9, 5), ch.voidPromise());
        this.registeredFutureLatch.release(null);
        ScheduledFuture old = this.keepAliveFuture.getAndSet(ch.eventLoop().scheduleWithFixedDelay((Runnable)new KeepAliveTask(), 20L, 10L, TimeUnit.SECONDS));
        if (old != null) {
            old.cancel(false);
        }
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        ScheduledFuture<?> future = this.keepAliveFuture.get();
        if (future != null) {
            future.cancel(false);
        }
        this.channel.set(null);
        log.info("Connection drop observed with endpoint {}", (Object)this.connectionName);
        this.flowIdReplyProcessorMap.forEach((flowId, rp) -> {
            try {
                log.debug("Connection dropped for flow id {}", flowId);
                rp.connectionDropped();
            }
            catch (Exception e) {
                log.warn("Encountered exception invoking ReplyProcessor for flow id {}", flowId, (Object)e);
            }
        });
        this.registeredFutureLatch.releaseExceptionally((Throwable)new ConnectionClosedException());
        super.channelUnregistered(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        WireCommands.DataAppended dataAppended;
        AppendBatchSizeTracker batchSizeTracker;
        Reply cmd = (Reply)msg;
        log.debug(this.connectionName + " processing reply {} with flow {}", (Object)cmd, (Object)Flow.from(cmd.getRequestId()));
        if (cmd instanceof WireCommands.Hello) {
            this.flowIdReplyProcessorMap.forEach((flowId, rp) -> {
                try {
                    rp.hello((WireCommands.Hello)cmd);
                }
                catch (Exception e) {
                    log.warn("Encountered exception invoking ReplyProcessor.hello for flow id {}", flowId, (Object)e);
                }
            });
            return;
        }
        if (cmd instanceof WireCommands.DataAppended && (batchSizeTracker = this.getAppendBatchSizeTracker((dataAppended = (WireCommands.DataAppended)cmd).getRequestId())) != null) {
            long pendingAckCount = batchSizeTracker.recordAck(dataAppended.getEventNumber());
            this.metricNotifier.updateSuccessMetric(ClientMetricKeys.CLIENT_OUTSTANDING_APPEND_COUNT, StreamSegmentNameUtils.writerTags((String)dataAppended.getWriterId().toString()), pendingAckCount);
        }
        this.getReplyProcessor(cmd).ifPresent(processor -> {
            try {
                processor.process(cmd);
            }
            catch (Exception e) {
                log.warn("ReplyProcessor.process failed for reply {} due to {}", (Object)cmd, (Object)e.getMessage());
                processor.processingFailure(e);
            }
        });
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.invokeProcessingFailureForAllFlows(cause);
    }

    private void invokeProcessingFailureForAllFlows(Throwable cause) {
        this.flowIdReplyProcessorMap.forEach((flowId, rp) -> {
            try {
                log.debug("Exception observed for flow id {} due to {}", flowId, (Object)cause.getMessage());
                rp.processingFailure((Exception)new ConnectionFailedException(cause));
            }
            catch (Exception e) {
                log.warn("Encountered exception invoking ReplyProcessor.processingFailure for flow id {}", flowId, (Object)e);
            }
        });
    }

    @Override
    public void close() {
        Channel ch;
        if (this.closed.compareAndSet(false, true) && (ch = (Channel)this.channel.getAndSet(null)) != null) {
            int appendTrackerCount;
            log.info("Closing connection with endpoint {} on channel {}", (Object)this.connectionName, (Object)ch);
            int openFlowCount = this.flowIdReplyProcessorMap.size();
            if (openFlowCount != 0) {
                log.debug("{} flows are not closed", (Object)openFlowCount);
                this.invokeProcessingFailureForAllFlows(new ConnectionClosedException());
            }
            if ((appendTrackerCount = this.flowIDBatchSizeTrackerMap.size()) != 0) {
                log.warn("{} AppendBatchSizeTrackers are not closed", (Object)appendTrackerCount);
            }
            ch.close();
        }
    }

    private Optional<ReplyProcessor> getReplyProcessor(Reply cmd) {
        int flowId = this.disableFlow.get() ? 0 : Flow.toFlowID(cmd.getRequestId());
        ReplyProcessor processor = this.flowIdReplyProcessorMap.get(flowId);
        if (processor == null) {
            log.warn("No ReplyProcessor found for the provided flowId {}. Ignoring response", (Object)flowId);
        }
        return Optional.ofNullable(processor);
    }

    @SuppressFBWarnings(justification="generated code")
    public MetricNotifier getMetricNotifier() {
        return this.metricNotifier;
    }

    @SuppressFBWarnings(justification="generated code")
    public ReusableFutureLatch<Void> getRegisteredFutureLatch() {
        return this.registeredFutureLatch;
    }

    @SuppressFBWarnings(justification="generated code")
    ConcurrentHashMap<Integer, ReplyProcessor> getFlowIdReplyProcessorMap() {
        return this.flowIdReplyProcessorMap;
    }

    private final class KeepAliveTask
    implements Runnable {
        private KeepAliveTask() {
        }

        @Override
        public void run() {
            try {
                if (!FlowHandler.this.recentMessage.getAndSet(false)) {
                    Futures.getAndHandleExceptions((Future)FlowHandler.this.getChannel().writeAndFlush((Object)new WireCommands.KeepAlive()), ConnectionFailedException::new);
                }
            }
            catch (Exception e) {
                log.warn("Keep alive failed, killing connection {} due to {}", (Object)FlowHandler.this.connectionName, (Object)e.getMessage());
                FlowHandler.this.close();
            }
        }
    }
}

