/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.segment.impl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.segment.impl.EndOfSegmentException;
import io.pravega.client.segment.impl.EventSegmentReader;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.segment.impl.SegmentInputStream;
import io.pravega.client.segment.impl.SegmentTruncatedException;
import io.pravega.common.LoggerHelpers;
import io.pravega.shared.protocol.netty.InvalidMessageException;
import io.pravega.shared.protocol.netty.WireCommandType;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventSegmentReaderImpl
implements EventSegmentReader {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(EventSegmentReaderImpl.class);
    @SuppressFBWarnings(justification="generated code")
    private final Object $lock = new Object[0];
    @GuardedBy(value="$lock")
    private final ByteBuffer headerReadingBuffer = ByteBuffer.allocate(8);
    private final SegmentInputStream in;

    EventSegmentReaderImpl(SegmentInputStream input) {
        Preconditions.checkNotNull((Object)input);
        this.in = input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOffset(long offset) {
        Object object = this.$lock;
        synchronized (object) {
            this.in.setOffset(offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getOffset() {
        Object object = this.$lock;
        synchronized (object) {
            return this.in.getOffset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer read(long timeout) throws EndOfSegmentException, SegmentTruncatedException {
        Object object = this.$lock;
        synchronized (object) {
            ByteBuffer byteBuffer;
            long originalOffset = this.in.getOffset();
            long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"read", (Object[])new Object[]{this.in.getSegmentId(), originalOffset, timeout});
            boolean success = false;
            try {
                ByteBuffer result = this.readEvent(timeout);
                success = true;
                byteBuffer = result;
            }
            catch (Throwable throwable) {
                LoggerHelpers.traceLeave((Logger)log, (String)"read", (long)traceId, (Object[])new Object[]{this.in.getSegmentId(), originalOffset, timeout, success});
                if (!success) {
                    this.in.setOffset(originalOffset);
                }
                throw throwable;
            }
            LoggerHelpers.traceLeave((Logger)log, (String)"read", (long)traceId, (Object[])new Object[]{this.in.getSegmentId(), originalOffset, timeout, success});
            if (!success) {
                this.in.setOffset(originalOffset);
            }
            return byteBuffer;
        }
    }

    public ByteBuffer readEvent(long timeout) throws EndOfSegmentException, SegmentTruncatedException {
        this.headerReadingBuffer.clear();
        int read = this.in.read(this.headerReadingBuffer, timeout);
        if (read == 0) {
            return null;
        }
        while (this.headerReadingBuffer.hasRemaining()) {
            this.in.read(this.headerReadingBuffer, Long.MAX_VALUE);
        }
        this.headerReadingBuffer.flip();
        int type = this.headerReadingBuffer.getInt();
        int length = this.headerReadingBuffer.getInt();
        if (type != WireCommandType.EVENT.getCode()) {
            throw new InvalidMessageException("Event was of wrong type: " + type);
        }
        if (length < 0 || length > 0x7FFFFF) {
            throw new InvalidMessageException("Event of invalid length: " + length);
        }
        ByteBuffer result = ByteBuffer.allocate(length);
        this.in.read(result, Long.MAX_VALUE);
        while (result.hasRemaining()) {
            this.in.read(result, Long.MAX_VALUE);
        }
        result.flip();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<?> fillBuffer() {
        Object object = this.$lock;
        synchronized (object) {
            return this.in.fillBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.$lock;
        synchronized (object) {
            this.in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSegmentReady() {
        Object object = this.$lock;
        synchronized (object) {
            int bytesInBuffer = this.in.bytesInBuffer();
            return bytesInBuffer >= 8 || bytesInBuffer < 0;
        }
    }

    @Override
    public Segment getSegmentId() {
        return this.in.getSegmentId();
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "EventSegmentReaderImpl(headerReadingBuffer=" + this.headerReadingBuffer + ", in=" + this.in + ")";
    }
}

