/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.Serializable;

public class EventWriterConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int initalBackoffMillis;
    private final int maxBackoffMillis;
    private final int retryAttempts;
    private final int backoffMultiple;
    private final boolean enableConnectionPooling;
    private final long transactionTimeoutTime;
    private final boolean automaticallyNoteTime;

    @ConstructorProperties(value={"initalBackoffMillis", "maxBackoffMillis", "retryAttempts", "backoffMultiple", "enableConnectionPooling", "transactionTimeoutTime", "automaticallyNoteTime"})
    @SuppressFBWarnings(justification="generated code")
    EventWriterConfig(int initalBackoffMillis, int maxBackoffMillis, int retryAttempts, int backoffMultiple, boolean enableConnectionPooling, long transactionTimeoutTime, boolean automaticallyNoteTime) {
        this.initalBackoffMillis = initalBackoffMillis;
        this.maxBackoffMillis = maxBackoffMillis;
        this.retryAttempts = retryAttempts;
        this.backoffMultiple = backoffMultiple;
        this.enableConnectionPooling = enableConnectionPooling;
        this.transactionTimeoutTime = transactionTimeoutTime;
        this.automaticallyNoteTime = automaticallyNoteTime;
    }

    @SuppressFBWarnings(justification="generated code")
    public static EventWriterConfigBuilder builder() {
        return new EventWriterConfigBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public int getInitalBackoffMillis() {
        return this.initalBackoffMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getMaxBackoffMillis() {
        return this.maxBackoffMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getBackoffMultiple() {
        return this.backoffMultiple;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isEnableConnectionPooling() {
        return this.enableConnectionPooling;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getTransactionTimeoutTime() {
        return this.transactionTimeoutTime;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isAutomaticallyNoteTime() {
        return this.automaticallyNoteTime;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventWriterConfig)) {
            return false;
        }
        EventWriterConfig other = (EventWriterConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInitalBackoffMillis() != other.getInitalBackoffMillis()) {
            return false;
        }
        if (this.getMaxBackoffMillis() != other.getMaxBackoffMillis()) {
            return false;
        }
        if (this.getRetryAttempts() != other.getRetryAttempts()) {
            return false;
        }
        if (this.getBackoffMultiple() != other.getBackoffMultiple()) {
            return false;
        }
        if (this.isEnableConnectionPooling() != other.isEnableConnectionPooling()) {
            return false;
        }
        if (this.getTransactionTimeoutTime() != other.getTransactionTimeoutTime()) {
            return false;
        }
        return this.isAutomaticallyNoteTime() == other.isAutomaticallyNoteTime();
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof EventWriterConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getInitalBackoffMillis();
        result = result * 59 + this.getMaxBackoffMillis();
        result = result * 59 + this.getRetryAttempts();
        result = result * 59 + this.getBackoffMultiple();
        result = result * 59 + (this.isEnableConnectionPooling() ? 79 : 97);
        long $transactionTimeoutTime = this.getTransactionTimeoutTime();
        result = result * 59 + (int)($transactionTimeoutTime >>> 32 ^ $transactionTimeoutTime);
        result = result * 59 + (this.isAutomaticallyNoteTime() ? 79 : 97);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "EventWriterConfig(initalBackoffMillis=" + this.getInitalBackoffMillis() + ", maxBackoffMillis=" + this.getMaxBackoffMillis() + ", retryAttempts=" + this.getRetryAttempts() + ", backoffMultiple=" + this.getBackoffMultiple() + ", enableConnectionPooling=" + this.isEnableConnectionPooling() + ", transactionTimeoutTime=" + this.getTransactionTimeoutTime() + ", automaticallyNoteTime=" + this.isAutomaticallyNoteTime() + ")";
    }

    public static final class EventWriterConfigBuilder {
        private static final long MIN_TRANSACTION_TIMEOUT_TIME_MILLIS = 10000L;
        private int initalBackoffMillis = 1;
        private int maxBackoffMillis = 20000;
        private int retryAttempts = 10;
        private int backoffMultiple = 10;
        private long transactionTimeoutTime = 89999L;
        private boolean automaticallyNoteTime = false;
        private boolean enableConnectionPooling = false;

        public EventWriterConfig build() {
            Preconditions.checkArgument((this.transactionTimeoutTime >= 10000L ? 1 : 0) != 0, (Object)"Transaction time must be at least 10 seconds.");
            Preconditions.checkArgument((this.initalBackoffMillis >= 0 ? 1 : 0) != 0, (Object)"Backoff times must be positive numbers");
            Preconditions.checkArgument((this.backoffMultiple >= 0 ? 1 : 0) != 0, (Object)"Backoff multiple must be positive numbers");
            Preconditions.checkArgument((this.maxBackoffMillis >= 0 ? 1 : 0) != 0, (Object)"Backoff times must be positive numbers");
            Preconditions.checkArgument((this.retryAttempts >= 0 ? 1 : 0) != 0, (Object)"Retry attempts must be a positive number");
            return new EventWriterConfig(this.initalBackoffMillis, this.maxBackoffMillis, this.retryAttempts, this.backoffMultiple, this.enableConnectionPooling, this.transactionTimeoutTime, this.automaticallyNoteTime);
        }

        @SuppressFBWarnings(justification="generated code")
        EventWriterConfigBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public EventWriterConfigBuilder initalBackoffMillis(int initalBackoffMillis) {
            this.initalBackoffMillis = initalBackoffMillis;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public EventWriterConfigBuilder maxBackoffMillis(int maxBackoffMillis) {
            this.maxBackoffMillis = maxBackoffMillis;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public EventWriterConfigBuilder retryAttempts(int retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public EventWriterConfigBuilder backoffMultiple(int backoffMultiple) {
            this.backoffMultiple = backoffMultiple;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public EventWriterConfigBuilder enableConnectionPooling(boolean enableConnectionPooling) {
            this.enableConnectionPooling = enableConnectionPooling;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public EventWriterConfigBuilder transactionTimeoutTime(long transactionTimeoutTime) {
            this.transactionTimeoutTime = transactionTimeoutTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public EventWriterConfigBuilder automaticallyNoteTime(boolean automaticallyNoteTime) {
            this.automaticallyNoteTime = automaticallyNoteTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "EventWriterConfig.EventWriterConfigBuilder(initalBackoffMillis=" + this.initalBackoffMillis + ", maxBackoffMillis=" + this.maxBackoffMillis + ", retryAttempts=" + this.retryAttempts + ", backoffMultiple=" + this.backoffMultiple + ", enableConnectionPooling=" + this.enableConnectionPooling + ", transactionTimeoutTime=" + this.transactionTimeoutTime + ", automaticallyNoteTime=" + this.automaticallyNoteTime + ")";
        }
    }
}

